/*
 * Decompiled with CFR 0.152.
 */
package fr.jetoile.hadoopunit.component;

import com.github.sakserv.minicluster.impl.KnoxLocalCluster;
import com.mycila.xmltool.XMLDoc;
import com.mycila.xmltool.XMLTag;
import fr.jetoile.hadoopunit.Component;
import fr.jetoile.hadoopunit.HadoopUtils;
import fr.jetoile.hadoopunit.component.Bootstrap;
import fr.jetoile.hadoopunit.component.KnoxService;
import fr.jetoile.hadoopunit.component.State;
import fr.jetoile.hadoopunit.exception.BootstrapException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnoxBootstrap
implements Bootstrap {
    public static final String NAME = Component.KNOX.name();
    private static final Logger LOGGER = LoggerFactory.getLogger(KnoxBootstrap.class);
    private KnoxLocalCluster knoxLocalCluster;
    private State state = State.STOPPED;
    private Configuration configuration;
    private String host;
    private int port;
    private String path;
    private String clusterName;
    private String tempDirectory;
    private List<KnoxService> services = new ArrayList<KnoxService>();
    private String namenodeUri;
    private String webHdfsUri;
    private String webHBaseUri;
    private String oozieUri;

    public KnoxBootstrap() {
        if (this.knoxLocalCluster == null) {
            try {
                this.configuration = HadoopUtils.INSTANCE.loadConfigFile(null);
                this.loadConfig();
            }
            catch (BootstrapException e) {
                LOGGER.error("unable to load configuration", (Throwable)e);
            }
        }
    }

    public KnoxBootstrap(URL url) {
        if (this.knoxLocalCluster == null) {
            try {
                this.configuration = HadoopUtils.INSTANCE.loadConfigFile(url);
                this.loadConfig();
            }
            catch (BootstrapException e) {
                LOGGER.error("unable to load configuration", (Throwable)e);
            }
        }
    }

    public String getName() {
        return NAME;
    }

    public String getProperties() {
        return "\n \t\t\t port:" + this.port + "\n \t\t\t path:" + this.path + "\n \t\t\t cluster:" + this.clusterName + "\n \t\t\t services:" + this.services.stream().map(s -> s.getName()).collect(Collectors.joining(", "));
    }

    private void init() {
    }

    private void build() {
        this.knoxLocalCluster = new KnoxLocalCluster.Builder().setHost(this.host).setPort(Integer.valueOf(this.port)).setPath(this.path).setCluster(this.clusterName).setHomeDir(this.tempDirectory).setTopology(this.getTopology(this.services)).build();
    }

    String getTopology(List<KnoxService> services) {
        XMLTag xmlTag = XMLDoc.newDocument((boolean)true).addRoot("topology").addTag("gateway").addTag("provider").addTag("role").addText("authentication").addTag("enabled").addText("false").gotoParent().addTag("provider").addTag("role").addText("identity-assertion").addTag("enabled").addText("false").gotoParent().gotoParent();
        for (KnoxService service : services) {
            switch (service) {
                case NAMENODE: {
                    xmlTag.addTag("service").addTag("role").addText(service.name()).addTag("url").addText(this.namenodeUri).gotoParent();
                    break;
                }
                case WEBHDFS: {
                    xmlTag.addTag("service").addTag("role").addText(service.name()).addTag("url").addText(this.webHdfsUri).gotoParent();
                    break;
                }
                case WEBHBASE: {
                    xmlTag.addTag("service").addTag("role").addText(service.name()).addTag("url").addText(this.webHBaseUri).gotoParent();
                    break;
                }
                case OOZIE: {
                    xmlTag.addTag("service").addTag("role").addText(service.name()).addTag("url").addText(this.oozieUri).gotoParent();
                }
            }
        }
        return xmlTag.toString();
    }

    private void loadConfig() throws BootstrapException {
        this.port = this.configuration.getInt("knox.port");
        this.host = this.configuration.getString("knox.host");
        this.path = this.configuration.getString("knox.path");
        this.clusterName = this.configuration.getString("knox.cluster");
        this.tempDirectory = this.configuration.getString("knox.home.dir");
        List<String> servicesList = Arrays.asList(this.configuration.getStringArray("knox.service"));
        this.services = Arrays.asList(KnoxService.values()).stream().filter(s -> servicesList.contains(s.getName())).collect(Collectors.toList());
        this.namenodeUri = "hdfs://" + this.configuration.getString("hdfs.namenode.host") + ":" + this.configuration.getString("hdfs.namenode.port");
        this.webHdfsUri = "http://" + this.configuration.getString("hdfs.namenode.host") + ":" + this.configuration.getString("hdfs.namenode.port") + "/webhdfs";
        this.webHBaseUri = "http://" + this.configuration.getString("hbase.rest.host") + ":" + this.configuration.getString("hbase.rest.port");
        this.oozieUri = "http://" + this.configuration.getString("oozie.host") + ":" + this.configuration.getString("oozie.port") + "/oozie";
    }

    public void loadConfig(Map<String, String> configs) {
        if (StringUtils.isNotEmpty((String)configs.get("knox.port"))) {
            this.port = Integer.parseInt(configs.get("knox.port"));
        }
        if (StringUtils.isNotEmpty((String)configs.get("knox.host"))) {
            this.host = configs.get("knox.host");
        }
        if (StringUtils.isNotEmpty((String)configs.get("knox.path"))) {
            this.path = configs.get("knox.path");
        }
        if (StringUtils.isNotEmpty((String)configs.get("knox.cluster"))) {
            this.clusterName = configs.get("knox.cluster");
        }
        if (StringUtils.isNotEmpty((String)configs.get("knox.home.dir"))) {
            this.tempDirectory = configs.get("knox.home.dir");
        }
        if (StringUtils.isNotEmpty((String)configs.get("knox.service"))) {
            List<String> servicesList = Arrays.asList(this.configuration.getStringArray("knox.service"));
            this.services = Arrays.asList(KnoxService.values()).stream().filter(s -> servicesList.contains(s.getName())).collect(Collectors.toList());
        }
        if (StringUtils.isNotEmpty((String)configs.get("hdfs.namenode.host")) && StringUtils.isNotEmpty((String)"hdfs.namenode.port")) {
            this.namenodeUri = "hdfs://" + configs.get("hdfs.namenode.host") + ":" + configs.get("hdfs.namenode.port");
            this.webHdfsUri = "http://" + configs.get("hdfs.namenode.host") + ":" + configs.get("hdfs.namenode.port") + "/webhdfs";
        }
        if (StringUtils.isNotEmpty((String)configs.get("hbase.rest.host")) && StringUtils.isNotEmpty((String)"hbase.rest.port")) {
            this.webHBaseUri = "http://" + configs.get("hbase.rest.host") + ":" + configs.get("hbase.rest.port");
        }
        if (StringUtils.isNotEmpty((String)configs.get("oozie.host")) && StringUtils.isNotEmpty((String)"oozie.port")) {
            this.webHBaseUri = "http://" + configs.get("oozie.host") + ":" + configs.get("oozie.port");
        }
    }

    public Bootstrap start() {
        if (this.state == State.STOPPED) {
            this.state = State.STARTING;
            LOGGER.info("{} is starting", (Object)this.getClass().getName());
            this.init();
            this.build();
            try {
                this.knoxLocalCluster.start();
            }
            catch (Exception e) {
                LOGGER.error("unable to add knox", (Throwable)e);
            }
            this.state = State.STARTED;
            LOGGER.info("{} is started", (Object)this.getClass().getName());
        }
        return this;
    }

    public Bootstrap stop() {
        if (this.state == State.STARTED) {
            this.state = State.STOPPING;
            LOGGER.info("{} is stopping", (Object)this.getClass().getName());
            try {
                this.knoxLocalCluster.stop(true);
            }
            catch (Exception e) {
                LOGGER.error("unable to stop knox", (Throwable)e);
            }
            this.state = State.STOPPED;
            LOGGER.info("{} is stopped", (Object)this.getClass().getName());
        }
        return this;
    }
}

