/*
 * Decompiled with CFR 0.152.
 */
package fr.jetoile.hadoopunit.component;

import fr.jetoile.hadoopunit.ComponentMetadata;
import fr.jetoile.hadoopunit.HadoopUtils;
import fr.jetoile.hadoopunit.component.Bootstrap;
import fr.jetoile.hadoopunit.component.PulsarStandaloneMetadata;
import fr.jetoile.hadoopunit.component.State;
import fr.jetoile.hadoopunit.exception.BootstrapException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.PulsarStandalone;
import org.apache.pulsar.PulsarStandaloneBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarStandaloneBootstrap
implements Bootstrap {
    private static final Logger LOGGER = LoggerFactory.getLogger(PulsarStandaloneBootstrap.class);
    private State state = State.STOPPED;
    private Configuration configuration;
    private int port;
    private String ip;
    private String tmpDirPath;
    private String zookeeperDir;
    private int zookeeperPort;
    private PulsarStandalone pulsarStandalone;

    public PulsarStandaloneBootstrap() {
        try {
            this.configuration = HadoopUtils.INSTANCE.loadConfigFile(null);
            this.loadConfig();
        }
        catch (BootstrapException e) {
            LOGGER.error("unable to load configuration", (Throwable)e);
        }
    }

    public PulsarStandaloneBootstrap(URL url) {
        try {
            this.configuration = HadoopUtils.INSTANCE.loadConfigFile(url);
            this.loadConfig();
        }
        catch (BootstrapException e) {
            LOGGER.error("unable to load configuration", (Throwable)e);
        }
    }

    public ComponentMetadata getMetadata() {
        return new PulsarStandaloneMetadata();
    }

    public String getProperties() {
        return "\n \t\t\t ip:" + this.ip + "\n \t\t\t port:" + this.port + "\n \t\t\t zookeeper port:" + this.zookeeperPort;
    }

    private void loadConfig() {
        this.port = this.configuration.getInt("pulsar.port");
        this.ip = this.configuration.getString("pulsar.ip");
        this.tmpDirPath = this.getTmpDirPath(this.configuration, "pulsar.temp.dir");
        this.zookeeperDir = this.getTmpDirPath(this.configuration, "pulsar.zookeeper.temp.dir");
        this.zookeeperPort = this.configuration.getInt("pulsar.zookeeper.port");
    }

    public void loadConfig(Map<String, String> configs) {
        if (StringUtils.isNotEmpty((CharSequence)configs.get("pulsar.port"))) {
            this.port = Integer.parseInt(configs.get("pulsar.port"));
        }
        if (StringUtils.isNotEmpty((CharSequence)configs.get("pulsar.ip"))) {
            this.ip = configs.get("pulsar.ip");
        }
        if (StringUtils.isNotEmpty((CharSequence)configs.get("pulsar.temp.dir"))) {
            this.tmpDirPath = this.getTmpDirPath(configs, "pulsar.temp.dir");
        }
        if (StringUtils.isNotEmpty((CharSequence)configs.get("pulsar.zookeeper.temp.dir"))) {
            this.zookeeperDir = this.getTmpDirPath(configs, "pulsar.zookeeper.temp.dir");
        }
        if (StringUtils.isNotEmpty((CharSequence)configs.get("pulsar.zookeeper.port"))) {
            this.zookeeperPort = Integer.parseInt(configs.get("pulsar.zookeeper.port"));
        }
    }

    private void build() throws IOException {
        File tmpDirectory = new File(this.tmpDirPath);
        tmpDirectory.mkdirs();
        this.pulsarStandalone = PulsarStandaloneBuilder.instance().withAdvertisedAddress(this.ip).withZkDir(this.zookeeperDir).withZkPort(this.zookeeperPort).withBkDir(this.tmpDirPath + "/data/standalone/bookkeeper").build();
        File tempFile = File.createTempFile("standalone-", "-embedded.conf", tmpDirectory);
        this.pulsarStandalone.getConfig().setBrokerServicePort(Optional.of(this.port));
        this.pulsarStandalone.setConfigFile(tempFile.getAbsolutePath());
    }

    public Bootstrap start() {
        if (this.state == State.STOPPED) {
            this.state = State.STARTING;
            LOGGER.info("{} is starting", (Object)this.getClass().getName());
            try {
                this.build();
                this.pulsarStandalone.start();
            }
            catch (Exception e) {
                LOGGER.error("unable to add pulsar", (Throwable)e);
            }
            this.state = State.STARTED;
            LOGGER.info("{} is started", (Object)this.getClass().getName());
        }
        return this;
    }

    public Bootstrap stop() {
        if (this.state == State.STARTED) {
            this.state = State.STOPPING;
            LOGGER.info("{} is stopping", (Object)this.getClass().getName());
            try {
                this.pulsarStandalone.close();
                this.cleanup();
            }
            catch (Exception e) {
                LOGGER.error("unable to stop pulsar", (Throwable)e);
            }
            this.state = State.STOPPED;
            LOGGER.info("{} is stopped", (Object)this.getClass().getName());
        }
        return this;
    }

    private void cleanup() {
        try {
            FileUtils.deleteDirectory((File)Paths.get(this.tmpDirPath, new String[0]).toFile());
        }
        catch (IOException e) {
            LOGGER.error("unable to delete {}", (Object)this.tmpDirPath, (Object)e);
        }
    }
}

