/*
 * Decompiled with CFR 0.152.
 */
package fr.jetoile.hadoopunit.component;

import com.github.sakserv.minicluster.impl.YarnLocalCluster;
import com.github.sakserv.minicluster.util.FileUtils;
import com.github.sakserv.minicluster.yarn.InJvmContainerExecutor;
import fr.jetoile.hadoopunit.ComponentMetadata;
import fr.jetoile.hadoopunit.HadoopUtils;
import fr.jetoile.hadoopunit.component.Bootstrap;
import fr.jetoile.hadoopunit.component.BootstrapHadoop;
import fr.jetoile.hadoopunit.component.State;
import fr.jetoile.hadoopunit.component.YarnMetadata;
import fr.jetoile.hadoopunit.exception.BootstrapException;
import fr.jetoile.hadoopunit.exception.NotFoundServiceException;
import java.io.File;
import java.net.URL;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnBootstrap
implements BootstrapHadoop {
    private final Logger LOGGER = LoggerFactory.getLogger(YarnBootstrap.class);
    private State state = State.STOPPED;
    private Configuration configuration;
    private YarnLocalCluster yarnLocalCluster = null;
    private int yarnNumNodeManagers;
    private int yarnNumLocalDirs;
    private int yarnNumLogDirs;
    private String yarnRMAddress;
    private String yarnRMHostname;
    private String yarnRMSchedulerAddress;
    private String yarnRMResourceTrackerAddress;
    private String yarnRMWebappAddress;
    private boolean inJvmContainer;

    public YarnBootstrap() {
        if (this.yarnLocalCluster == null) {
            try {
                this.configuration = HadoopUtils.INSTANCE.loadConfigFile(null);
                this.loadConfig();
            }
            catch (BootstrapException | NotFoundServiceException e) {
                this.LOGGER.error("unable to load configuration", e);
            }
        }
    }

    public YarnBootstrap(URL url) {
        if (this.yarnLocalCluster == null) {
            try {
                this.configuration = HadoopUtils.INSTANCE.loadConfigFile(url);
                this.loadConfig();
            }
            catch (BootstrapException | NotFoundServiceException e) {
                this.LOGGER.error("unable to load configuration", e);
            }
        }
    }

    private void init() {
    }

    public ComponentMetadata getMetadata() {
        return new YarnMetadata();
    }

    public String getProperties() {
        return "\n \t\t\t RM address:" + this.yarnRMAddress + "\n \t\t\t RM Scheduler address:" + this.yarnRMSchedulerAddress + "\n \t\t\t RM Resource Tracker address:" + this.yarnRMResourceTrackerAddress + "\n \t\t\t RM Webapp address:" + this.yarnRMWebappAddress + "\n \t\t\t InJvmContainer:" + this.inJvmContainer;
    }

    private void build() throws NotFoundServiceException {
        this.yarnLocalCluster = new YarnLocalCluster.Builder().setNumNodeManagers(Integer.valueOf(this.yarnNumNodeManagers)).setNumLocalDirs(Integer.valueOf(this.yarnNumLocalDirs)).setNumLogDirs(Integer.valueOf(this.yarnNumLogDirs)).setResourceManagerAddress(this.yarnRMAddress).setResourceManagerHostname(this.yarnRMHostname).setResourceManagerSchedulerAddress(this.yarnRMSchedulerAddress).setResourceManagerResourceTrackerAddress(this.yarnRMResourceTrackerAddress).setResourceManagerWebappAddress(this.yarnRMWebappAddress).setUseInJvmContainerExecutor(Boolean.valueOf(this.inJvmContainer)).setConfig(new org.apache.hadoop.conf.Configuration()).build();
    }

    private void loadConfig() throws BootstrapException, NotFoundServiceException {
        this.yarnNumNodeManagers = this.configuration.getInt("yarn.num.node.managers");
        this.yarnNumLocalDirs = this.configuration.getInt("yarn.num.local.dirs");
        this.yarnNumLogDirs = this.configuration.getInt("yarn.num.log.dirs");
        this.yarnRMAddress = this.configuration.getString("yarn.resource.manager.address");
        this.yarnRMHostname = this.configuration.getString("yarn.resource.manager.hostname");
        this.yarnRMSchedulerAddress = this.configuration.getString("yarn.resource.manager.scheduler.address");
        this.yarnRMResourceTrackerAddress = this.configuration.getString("yarn.resource.manager.resource.tracker.address");
        this.yarnRMWebappAddress = this.configuration.getString("yarn.resource.manager.webapp.address");
        this.inJvmContainer = this.configuration.getBoolean("yarn.use.in.jvm.container.executor");
    }

    public void loadConfig(Map<String, String> configs) {
        if (StringUtils.isNotEmpty((String)configs.get("yarn.num.node.managers"))) {
            this.yarnNumNodeManagers = Integer.parseInt(configs.get("yarn.num.node.managers"));
        }
        if (StringUtils.isNotEmpty((String)configs.get("yarn.num.local.dirs"))) {
            this.yarnNumLocalDirs = Integer.parseInt(configs.get("yarn.num.local.dirs"));
        }
        if (StringUtils.isNotEmpty((String)configs.get("yarn.num.log.dirs"))) {
            this.yarnNumLogDirs = Integer.parseInt(configs.get("yarn.num.log.dirs"));
        }
        if (StringUtils.isNotEmpty((String)configs.get("yarn.resource.manager.address"))) {
            this.yarnRMAddress = configs.get("yarn.resource.manager.address");
        }
        if (StringUtils.isNotEmpty((String)configs.get("yarn.resource.manager.hostname"))) {
            this.yarnRMHostname = configs.get("yarn.resource.manager.hostname");
        }
        if (StringUtils.isNotEmpty((String)configs.get("yarn.resource.manager.scheduler.address"))) {
            this.yarnRMSchedulerAddress = configs.get("yarn.resource.manager.scheduler.address");
        }
        if (StringUtils.isNotEmpty((String)configs.get("yarn.resource.manager.resource.tracker.address"))) {
            this.yarnRMResourceTrackerAddress = configs.get("yarn.resource.manager.resource.tracker.address");
        }
        if (StringUtils.isNotEmpty((String)configs.get("yarn.resource.manager.webapp.address"))) {
            this.yarnRMWebappAddress = configs.get("yarn.resource.manager.webapp.address");
        }
        if (StringUtils.isNotEmpty((String)configs.get("yarn.use.in.jvm.container.executor"))) {
            this.inJvmContainer = Boolean.parseBoolean(configs.get("yarn.use.in.jvm.container.executor"));
        }
    }

    public Bootstrap start() {
        if (this.state == State.STOPPED) {
            this.state = State.STARTING;
            this.LOGGER.info("{} is starting", (Object)this.getClass().getName());
            this.init();
            try {
                this.build();
            }
            catch (NotFoundServiceException e) {
                this.LOGGER.error("unable to add yarn", (Throwable)e);
            }
            try {
                this.yarnLocalCluster.start();
            }
            catch (Exception e) {
                this.LOGGER.error("unable to add yarn", (Throwable)e);
            }
            this.state = State.STARTED;
            this.LOGGER.info("{} is started", (Object)this.getClass().getName());
        }
        return this;
    }

    public Bootstrap stop() {
        if (this.state == State.STARTED) {
            this.state = State.STOPPING;
            this.LOGGER.info("{} is stopping", (Object)this.getClass().getName());
            try {
                System.setSecurityManager((SecurityManager)new InJvmContainerExecutor.SystemExitAllowSecurityManager());
                this.yarnLocalCluster.stop();
                this.cleanup();
            }
            catch (Exception e) {
                this.LOGGER.error("unable to stop yarn", (Throwable)e);
            }
            this.state = State.STOPPED;
            this.LOGGER.info("{} is stopped", (Object)this.getClass().getName());
        }
        return this;
    }

    private void cleanup() {
        if (new File("./target/classes").exists()) {
            FileUtils.deleteFolder((String)("./target/" + this.getTestName()));
        } else {
            FileUtils.deleteFolder((String)"./target");
        }
    }

    public org.apache.hadoop.conf.Configuration getConfiguration() {
        return this.yarnLocalCluster.getConfig();
    }

    public String getTestName() {
        return this.yarnLocalCluster.getTestName();
    }
}

