package configuration_file_parser;

import java.util.List;

import api.definition.config.IExport;
import export.constants.ExportConstants;

public class ParserConstants {

	public static final char ARRAY_DELIMITER = ',';
	public static final String KEY_DELIMITER = ".";
	public static final String KEY_DELIMITER_REGEX = "\\.";
	public static final String UNSET_VAR_REGEX = "\\$\\{[^\\}]+\\}";
	public static final String WARNING_PREFIX = "[WARNING] Parser: ";
	public static final String META_REASONER_KW = "meta" + KEY_DELIMITER + "reasoner";
	public static final String MIN_MEMORY_KW = "minMemory";
	public static final String MAX_MEMORY_KW = "maxMemory";
	public static final String EXECUTE_ONLY_KW = "executeOnly";
	public static final String EXECUTE_ONLY_DELIMITER_REGEX = "\\s+";
	public static final String EXECUTE_ONLY_FORALL_WILDCARD = "*";
	public static final String MULTISCENARIO_SEPARATOR = "@@@";

	/**
	 * List of keys that must be affected to true value if the value is missing
	 */
	// TODO : fix this
	public static final List<String> SET_TO_TRUE = List.of();//DBMSDriverParameters.CLEAR_DB.toString(),Algorithm.Answers.ANSWER_COUNT_ONLY.toString());
	public static final String CONFIGURATION_PREPROCESSED_FILE = ".preprocessedConfigurationFile.cf";

	public static Class<? extends IExport> getDefaultExporter() {

		return ExportConstants.getClassByName("xml");

	}
}
