package configuration_file_parser;

public enum SupportedFormatsConstants {

	/*
	 * 
	 * List of tools supported by BRunner.
	 * 
	 */
	DLGP("DLGP"), RDF("RDF"), XML("XML"), JSON("JSON"), CSV("CSV"), RLS("RLS"), BRUNNER("BRN");

	private final String name;

	SupportedFormatsConstants(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public static boolean isSupported(String fileExtension) {
		for (SupportedFormatsConstants type : SupportedFormatsConstants.values()) {
			if (type.name.equalsIgnoreCase(fileExtension)) {
				return true;
			}
		}
		return false;
	}

	public static String getListOfSupportedValues() {
		StringBuilder supportedFormatsList = new StringBuilder("");
		
		for (SupportedFormatsConstants type : SupportedFormatsConstants.values()) {
		
			supportedFormatsList.append(type.name + " ");

		}

		return supportedFormatsList.toString();
	}
}
