package configuration_file_parser.segment;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;

import api.definition.config.IExport;
import configuration_file_parser.ParserConstants;
import constants.BRunnerKeywords;
import export.constants.ExportConstants;

public class ExportClassesParser {

	public static Collection<Class<? extends IExport>> parse(Configuration apacheConfigurationObject)
			throws ConfigurationException, ClassNotFoundException {
		Set<String> fullPropertyNames = new LinkedHashSet<>();
		Set<String> exportNames = new LinkedHashSet<>();
		apacheConfigurationObject.getKeys(BRunnerKeywords.OuterLevel.EXPORT.kw).forEachRemaining(fullPropertyNames::add);

		for (String name : fullPropertyNames) {
			exportNames.add(name.replace(BRunnerKeywords.OuterLevel.EXPORT.kw + ".", ""));
		}

		Collection<Class<? extends IExport>> exportClasses = new HashSet<>(); 
		for (String exportNickname : exportNames) {
			Class<? extends IExport> exportClass = (Class<? extends IExport>) ExportConstants
					.getClassByName(exportNickname);

			exportClasses.add(exportClass);
		}

		if (exportClasses.isEmpty()) {
			exportClasses.add(ParserConstants.getDefaultExporter());
		}

		return exportClasses;
	}

}
