package configuration_file_parser.util;

import java.util.Collection;
import java.util.LinkedHashSet;

import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;

/**
 * A {@link IConfigurationFilePropertySet} building from a Java property file.
 * 
 * It holds a raw benchmark configurations only made by properties and values.
 * 
 *
 */
 class DefaultConfigurationFilePropertySet implements IConfigurationFilePropertySet {

	private String filepath;

	private PropertiesConfiguration benchmarkConfiguration;

	private char arrayDelimiter;

	public DefaultConfigurationFilePropertySet(String filepath, char arrayDelimiter) throws ConfigurationException {

		this.filepath = filepath;

		this.arrayDelimiter = arrayDelimiter;

		buildFromJavaPropertyFile();

	}

	/*
	 * 
	 * From {@link IPropertySet} interface
	 * 
	 */

	@Override
	public String getFilePath() {

		return this.filepath;

	}

	@Override
	public Collection<String> getSubPropertySet(String prefix) {

		Collection<String> result = new LinkedHashSet<String>();

		benchmarkConfiguration.getKeys().forEachRemaining(key -> {

			if (key.startsWith(prefix)) {

				result.add(key);

			}
		});

		return result;

	}

	public boolean containsProperty(String property) {

		return benchmarkConfiguration.containsKey(property) && benchmarkConfiguration.getString(property) != null
				&& benchmarkConfiguration.getString(property) != "";

	}

	public String getPropertyValue(String property) {

		if (!containsProperty(property))

			throw new IllegalArgumentException(
					"Key " + property + " not found in file " + filepath + ", or not value associated with");

		return benchmarkConfiguration.getString(property);

	}

	//////////////////////////////
	// Object Methods
	//////////////////////////////

	public String toString() {

		return defaultStringRepresentation();

	}
	//////////////////////////////
	// Private Methods
	//////////////////////////////

	/*
	 * 
	 * Reads the property file and builds the associated property set.
	 * 
	 */
	private void buildFromJavaPropertyFile() throws ConfigurationException {

		Parameters params = new Parameters();

		// Note : we are using org.apache.commons.configuration2

		FileBasedConfigurationBuilder<PropertiesConfiguration> builder = new FileBasedConfigurationBuilder<>(
				PropertiesConfiguration.class)
				.configure(params.properties().setListDelimiterHandler(new DefaultListDelimiterHandler(arrayDelimiter))
						.setFileName(filepath));

		this.benchmarkConfiguration = builder.getConfiguration();
	}

}
