/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.graal.apps;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import fr.lirmm.graphik.graal.api.core.Atom;
import fr.lirmm.graphik.graal.api.core.AtomSet;
import fr.lirmm.graphik.graal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.graal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.graal.api.core.Rule;
import fr.lirmm.graphik.graal.api.core.Substitution;
import fr.lirmm.graphik.graal.api.core.Term;
import fr.lirmm.graphik.graal.api.forward_chaining.ChaseHaltingCondition;
import fr.lirmm.graphik.graal.api.forward_chaining.RuleApplier;
import fr.lirmm.graphik.graal.api.homomorphism.Homomorphism;
import fr.lirmm.graphik.graal.core.DefaultConjunctiveQuery;
import fr.lirmm.graphik.graal.core.ruleset.LinkedListRuleSet;
import fr.lirmm.graphik.graal.cqa.AtomIndex;
import fr.lirmm.graphik.graal.cqa.FGH;
import fr.lirmm.graphik.graal.cqa.FGHRuleChaseCondition;
import fr.lirmm.graphik.graal.forward_chaining.NaiveChase;
import fr.lirmm.graphik.graal.forward_chaining.rule_applier.ExhaustiveRuleApplier;
import fr.lirmm.graphik.graal.io.dlp.DlgpParser;
import fr.lirmm.graphik.graal.store.rdbms.DefaultRdbmsStore;
import fr.lirmm.graphik.graal.store.rdbms.SqlHomomorphism;
import fr.lirmm.graphik.graal.store.rdbms.driver.RdbmsDriver;
import fr.lirmm.graphik.graal.store.rdbms.driver.SqliteDriver;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CLI_FGH {
    public final String PROGRAM_NAME = "graal-cli-fgh";
    @Parameter(names={"-S", "--chase", "--saturation"}, description="Execute chase")
    private boolean executingChase = false;
    @Parameter(names={"-C", "--conflicts", "--naive-conflicts"}, description="Compute naive conflicts")
    private boolean computingConflicts = false;
    @Parameter(names={"-I", "--index", "--compute-index"}, description="Compute index")
    private boolean computingIndex = false;
    @Parameter(names={"-W", "--basic-weights"}, description="Compute basic weights")
    private boolean computingBasicWeights = false;
    @Parameter(names={"-G", "--compute-fgh"}, description="Compute fact generation hypergraph")
    private boolean computingFGH = false;
    @Parameter(names={"-U", "--compute-ucq"}, description="Compute ucq (incompatible with compute conflicts)")
    private boolean computingUCQ = false;
    @Parameter(names={"-h", "--help"}, description="Print this message")
    private boolean help = false;
    @Parameter(names={"-d", "--db", "--db-file"}, description="Output database file")
    private String db_file = "_default_graal.db";
    @Parameter(names={"-f", "--input-file"}, description="Input DLP file")
    private String input_file = "-";
    @Parameter(names={"-i", "--index-file"}, description="Index file")
    private String index_file = "_default.index";
    @Parameter(names={"-w", "--basic-weight-file"}, description="Basic weights file")
    private String weight_file = "_default.basic-weights";
    @Parameter(names={"-g", "--fgh", "--fact-generation-file"}, description="Fact generation hypergraph file")
    private String fgh_file = "_default.fgh";
    @Parameter(names={"-c", "--conflicts-file", "--naive-conflicts-file"}, description="Naive conflicts file")
    private String conflict_file = "_default.naive-conflicts";
    @Parameter(names={"-u", "--ucq-file"}, description="UCQ output file")
    private String ucq_file = "_default.ucq_answers";

    public static void main(String ... args) {
        CLI_FGH options = new CLI_FGH();
        JCommander commander = new JCommander((Object)options, args);
        if (options.help) {
            commander.usage();
            System.exit(0);
        }
        try {
            CloseableIterator execute;
            DefaultConjunctiveQuery q;
            File f2;
            FileWriter out;
            FGHRuleChaseCondition chaseCondition;
            System.out.println("Initialising database file...");
            File f = new File(options.db_file);
            DefaultRdbmsStore atomset = new DefaultRdbmsStore((RdbmsDriver)new SqliteDriver(f));
            System.out.println("Done!");
            LinkedListRuleSet rules = new LinkedListRuleSet();
            LinkedList<ConjunctiveQuery> constraints = new LinkedList<ConjunctiveQuery>();
            System.out.println("Initialising atom index file...");
            AtomIndex index = new AtomIndex(options.index_file);
            System.out.println("Done!");
            FGH fgh = new FGH();
            SqlHomomorphism solver = SqlHomomorphism.instance();
            FGHRuleChaseCondition haltCondition = chaseCondition = new FGHRuleChaseCondition(index, fgh);
            ExhaustiveRuleApplier applier = new ExhaustiveRuleApplier((Homomorphism)solver, (ChaseHaltingCondition)haltCondition);
            NaiveChase chase = new NaiveChase((Iterable)rules, (AtomSet)atomset, (RuleApplier)applier);
            if (options.input_file != "") {
                System.out.println("Reading data from dlp file: " + options.input_file);
                InputStreamReader reader = options.input_file.equals("-") ? new InputStreamReader(System.in) : new FileReader(options.input_file);
                DlgpParser parser = new DlgpParser((Reader)reader);
                while (parser.hasNext()) {
                    Object o = parser.next();
                    if (o instanceof Atom) {
                        atomset.add((Atom)o);
                        continue;
                    }
                    if (o instanceof Rule) {
                        rules.add((Rule)o);
                        continue;
                    }
                    if (o instanceof ConjunctiveQuery) {
                        constraints.add((ConjunctiveQuery)o);
                        continue;
                    }
                    System.out.println("Ignoring non recognized object: " + o);
                }
                System.out.println("Done!");
            }
            System.out.println("Adding initial facts to index...");
            int init_size = 0;
            for (Atom a : atomset) {
                index.get(a);
                ++init_size;
            }
            System.out.println("Done!");
            if (options.executingChase) {
                System.out.println("Executing chase...");
                chase.execute();
                System.out.println("Done!");
            }
            System.out.println("Counting atoms...");
            int nbAtoms = 0;
            for (Atom a : atomset) {
                ++nbAtoms;
            }
            System.out.println("Done: " + nbAtoms);
            if (options.computingBasicWeights) {
                System.out.println("Creating basic weights file: " + options.weight_file);
                File wf = new File(options.weight_file);
                out = new FileWriter(wf);
                Pattern p = Pattern.compile("rule[0-9]+.*");
                out.write(nbAtoms);
                out.write("\n");
                for (int i = 0; i < nbAtoms; ++i) {
                    Atom a = index.get(i);
                    if (i < init_size) {
                        out.write("1.0 1.0\n");
                        continue;
                    }
                    Matcher m = p.matcher(a.getPredicate().getIdentifier().toString());
                    if (m.find()) {
                        out.write(((Term)((LinkedList)a.getTerms()).getLast()).getIdentifier().toString());
                    } else {
                        out.write("1.0");
                    }
                    out.write(" 0.0\n");
                }
                System.out.println("Done!");
            }
            if (options.computingFGH) {
                System.out.println("Creating FGH file...");
                fgh.writeToFile(options.fgh_file);
                System.out.println("Done!");
            }
            if (options.computingConflicts) {
                f2 = new File(options.conflict_file);
                out = new FileWriter(f2);
                for (ConjunctiveQuery constraint : constraints) {
                    q = new DefaultConjunctiveQuery(constraint);
                    q.setAnswerVariables(new LinkedList(q.getAtomSet().getTerms()));
                    execute = solver.execute((Object)q, (AtomSet)atomset);
                    while (execute.hasNext()) {
                        Substitution s = (Substitution)execute.next();
                        InMemoryAtomSet conflict = s.createImageOf((AtomSet)q.getAtomSet());
                        int conflict_size = 0;
                        for (Atom a : conflict) {
                            ++conflict_size;
                        }
                        out.write(conflict_size);
                        out.write(32);
                        for (Atom a : conflict) {
                            out.write(index.get(a));
                            out.write(32);
                        }
                        out.write("\n");
                    }
                }
            } else if (options.computingUCQ) {
                f2 = new File(options.ucq_file);
                out = new FileWriter(f2);
                for (ConjunctiveQuery constraint : constraints) {
                    q = new DefaultConjunctiveQuery(constraint);
                    q.setAnswerVariables(new LinkedList(q.getAtomSet().getTerms()));
                    execute = solver.execute((Object)q, (AtomSet)atomset);
                    while (execute.hasNext()) {
                        Substitution s = (Substitution)execute.next();
                        InMemoryAtomSet conflict = s.createImageOf((AtomSet)q.getAtomSet());
                        int conflict_size = 0;
                        for (Atom a : conflict) {
                            ++conflict_size;
                        }
                        out.write(conflict_size);
                        out.write(32);
                        for (Atom a : conflict) {
                            out.write(index.get(a));
                            out.write(32);
                        }
                        out.write("\n");
                    }
                }
            }
            if (options.computingIndex) {
                index.writeToFile();
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }
}

