/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.graal.cqa;

import fr.lirmm.graphik.graal.api.core.Atom;
import fr.lirmm.graphik.graal.io.dlp.DlgpParser;
import fr.lirmm.graphik.graal.io.dlp.DlgpWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AtomIndex {
    private TreeMap<Atom, Integer> _atomToIndex = new TreeMap();
    private TreeMap<Integer, Atom> _indexToAtom = new TreeMap();
    private int _currentIndex = 0;
    private boolean _hasBeenModified = false;
    private String _filepath;

    public AtomIndex(String filepath) {
        this._filepath = filepath;
        this.readFromFile();
        this._hasBeenModified = false;
    }

    protected void finalize() {
        if (this._hasBeenModified) {
            this.writeToFile();
        }
    }

    public void readFromFile() {
        try {
            File f = new File(this._filepath);
            Scanner in = new Scanner(f);
            Pattern p = Pattern.compile("([0-9]+) (.*)");
            while (in.hasNextLine()) {
                String line = in.nextLine();
                Matcher m = p.matcher(line);
                if (!m.find()) continue;
                int i = Integer.parseInt(m.group(1));
                Atom a = DlgpParser.parseAtom((String)m.group(2));
                this.add(a, new Integer(i));
                this._currentIndex = i > this._currentIndex ? i : this._currentIndex;
            }
        }
        catch (Exception e) {
            System.err.println("AtomIndex::readFromFilepath: " + e);
            e.printStackTrace();
        }
    }

    public void writeToFile() {
        try {
            File f = new File(this._filepath);
            FileWriter out = new FileWriter(f);
            Set<Integer> keys = this._indexToAtom.keySet();
            for (Integer i : keys) {
                out.write("" + i);
                out.write(32);
                out.write(DlgpWriter.writeToString((Object)this._indexToAtom.get(i)));
                out.write("\n");
            }
            this._hasBeenModified = false;
        }
        catch (Exception e) {
            System.err.println("AtomIndex::writeToFilepath: " + e);
            e.printStackTrace();
        }
    }

    public int get(Atom a) {
        Integer i = this._atomToIndex.get(a);
        if (i == null) {
            this.add(a);
            return this.get(a);
        }
        return this._atomToIndex.get(a);
    }

    public Atom get(int i) {
        return this._indexToAtom.get(new Integer(i));
    }

    public void add(Atom a, Integer i) {
        this._atomToIndex.put(a, i);
        this._indexToAtom.put(i, a);
        this._hasBeenModified = true;
    }

    public void add(Atom a) {
        this.add(a, new Integer(this._currentIndex));
        ++this._currentIndex;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        int i = 0;
        Atom a = this.get(i);
        while (a != null) {
            s.append(i);
            s.append("\t");
            s.append(a);
            s.append("\n");
            a = this.get(++i);
        }
        return s.toString();
    }
}

