/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.graal.cqa;

import java.io.File;
import java.io.FileWriter;
import java.util.Iterator;
import java.util.LinkedList;

public class FGH
implements Iterable<Edge> {
    private LinkedList<Edge> edges = new LinkedList();

    public void add(LinkedList<Integer> causes, int consequence) {
        if (!causes.contains(new Integer(consequence))) {
            Edge e = new Edge(causes, consequence);
            this.edges.add(e);
            this.filterSupsets();
        }
    }

    public void filterSupsets() {
        LinkedList<Edge> toRemove = new LinkedList<Edge>();
        for (Edge e : this.edges) {
            for (Edge e2 : this.edges) {
                if (e == e2 || !e.isSubset(e2)) continue;
                toRemove.add(e2);
            }
        }
        this.edges.removeAll(toRemove);
    }

    @Override
    public Iterator iterator() {
        return this.edges.iterator();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Edge e : this) {
            s.append(e);
            s.append("\n");
        }
        return s.toString();
    }

    public void writeToFile(String filepath) {
        try {
            File f = new File(filepath);
            FileWriter out = new FileWriter(f);
            int cpt = 0;
            for (Edge e : this) {
                ++cpt;
            }
            out.write("" + cpt);
            out.write("\n");
            for (Edge e : this) {
                cpt = 0;
                for (Integer i : e) {
                    ++cpt;
                }
                out.write("" + cpt);
                out.write(32);
                for (Integer i : e) {
                    out.write("" + i);
                    out.write(32);
                }
                out.write("\n");
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    public static class Edge
    implements Comparable<Edge>,
    Iterable<Integer> {
        private LinkedList<Integer> from = new LinkedList();
        private int to;

        public Edge(LinkedList<Integer> f, int t) {
            for (Integer i : f) {
                if (this.from.contains(i)) continue;
                this.from.add(i);
            }
            this.to = t;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append('{');
            boolean first = true;
            for (Integer i : this.from) {
                if (first) {
                    first = false;
                } else {
                    s.append(',');
                }
                s.append(i);
            }
            s.append('}');
            s.append(" --> ");
            s.append(this.to);
            return s.toString();
        }

        @Override
        public int compareTo(Edge e) {
            return 1;
        }

        public boolean isSubset(Edge e) {
            if (e.to != this.to) {
                return false;
            }
            for (Integer i : this.from) {
                if (e.from.contains(i)) continue;
                return false;
            }
            return true;
        }

        public int to() {
            return this.to;
        }

        @Override
        public Iterator iterator() {
            return this.from.iterator();
        }
    }
}

