/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.graal.cqa;

import fr.lirmm.graphik.graal.api.core.Atom;
import fr.lirmm.graphik.graal.api.core.AtomSet;
import fr.lirmm.graphik.graal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.graal.api.core.Query;
import fr.lirmm.graphik.graal.api.core.Rule;
import fr.lirmm.graphik.graal.api.core.Substitution;
import fr.lirmm.graphik.graal.api.core.Term;
import fr.lirmm.graphik.graal.api.core.VariableGenerator;
import fr.lirmm.graphik.graal.api.forward_chaining.ChaseHaltingCondition;
import fr.lirmm.graphik.graal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.graal.api.homomorphism.HomomorphismFactoryException;
import fr.lirmm.graphik.graal.core.DefaultVariableGenerator;
import fr.lirmm.graphik.graal.cqa.AtomIndex;
import fr.lirmm.graphik.graal.cqa.FGH;
import fr.lirmm.graphik.graal.forward_chaining.halting_condition.ConjunctiveQueryWithFixedVariables;
import fr.lirmm.graphik.graal.homomorphism.StaticHomomorphism;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.GIterator;
import fr.lirmm.graphik.util.stream.IteratorAdapter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;

public class FGHRuleChaseCondition
implements ChaseHaltingCondition {
    private AtomIndex index;
    private FGH fgh;
    private VariableGenerator existentialGen;

    public FGHRuleChaseCondition(AtomIndex index, FGH fgh) {
        this.index = index;
        this.fgh = fgh;
        this.existentialGen = new DefaultVariableGenerator("EE");
    }

    public FGHRuleChaseCondition(AtomIndex index, FGH fgh, VariableGenerator existentialGen) {
        this.index = index;
        this.fgh = fgh;
        this.existentialGen = existentialGen;
    }

    public GIterator<Atom> apply(Rule rule, Substitution substitution, AtomSet data) throws HomomorphismFactoryException, HomomorphismException {
        Set fixedVars = substitution.getValues();
        for (Term t : rule.getExistentials()) {
            substitution.put(t, (Term)this.existentialGen.getFreshVar());
        }
        LinkedList<Integer> causes = new LinkedList<Integer>();
        for (Atom a : substitution.createImageOf((AtomSet)rule.getBody())) {
            causes.add(new Integer(this.index.get(a)));
        }
        InMemoryAtomSet newFacts = substitution.createImageOf((AtomSet)rule.getHead());
        ConjunctiveQueryWithFixedVariables query = new ConjunctiveQueryWithFixedVariables((AtomSet)newFacts, (Iterable)fixedVars);
        CloseableIterator executeQuery = StaticHomomorphism.instance().execute((Query)query, data);
        if (executeQuery.hasNext()) {
            while (executeQuery.hasNext()) {
                Substitution next = (Substitution)executeQuery.next();
                for (Atom a : newFacts) {
                    this.fgh.add(causes, this.index.get(next.createImageOf(a)));
                }
            }
            return new IteratorAdapter(Collections.emptyList().iterator());
        }
        for (Atom a : newFacts) {
            this.fgh.add(causes, this.index.get(a));
        }
        return newFacts.iterator();
    }
}

