/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.graal.homomorphism;

import fr.lirmm.graphik.graal.api.core.Atom;
import fr.lirmm.graphik.graal.api.core.AtomSet;
import fr.lirmm.graphik.graal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.graal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.graal.api.core.Substitution;
import fr.lirmm.graphik.graal.api.core.Term;
import fr.lirmm.graphik.graal.api.core.stream.SubstitutionReader;
import fr.lirmm.graphik.graal.api.homomorphism.Homomorphism;
import fr.lirmm.graphik.graal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.graal.core.BuiltInPredicate;
import fr.lirmm.graphik.graal.core.atomset.LinkedListAtomSet;
import fr.lirmm.graphik.graal.core.factory.ConjunctiveQueryFactory;
import java.util.Iterator;
import java.util.LinkedList;

public class ComplexHomomorphism<Q extends ConjunctiveQuery, F extends AtomSet>
implements Homomorphism<Q, F> {
    private Homomorphism<ConjunctiveQuery, F> rawSolver;
    private LinkedList<Atom> builtInAtoms;

    public ComplexHomomorphism(Homomorphism<ConjunctiveQuery, F> rawSolver) {
        this.rawSolver = rawSolver;
    }

    public <U1 extends Q, U2 extends F> SubstitutionReader execute(U1 q, U2 f) throws HomomorphismException {
        LinkedListAtomSet rawAtoms = new LinkedListAtomSet();
        this.builtInAtoms = new LinkedList();
        for (Atom a : q) {
            if (a.getPredicate() instanceof BuiltInPredicate) {
                this.builtInAtoms.add(a);
                continue;
            }
            rawAtoms.add(a);
        }
        ConjunctiveQuery rawQuery = ConjunctiveQueryFactory.instance().create((InMemoryAtomSet)rawAtoms);
        rawQuery.setAnswerVariables(q.getAnswerVariables());
        return new BuiltInSubstitutionReader(this.rawSolver.execute((Object)rawQuery, f));
    }

    protected class BuiltInSubstitutionReader
    implements SubstitutionReader {
        private Substitution next;
        private SubstitutionReader rawReader;

        public BuiltInSubstitutionReader(SubstitutionReader reader) {
            this.rawReader = reader;
        }

        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.computeNext();
            }
            return this.next != null;
        }

        public Substitution next() {
            this.hasNext();
            Substitution res = this.next;
            this.next = null;
            return res;
        }

        protected Substitution computeNext() {
            if (this.rawReader.hasNext()) {
                Substitution res = this.rawReader.next();
                if (this.check(res)) {
                    return res;
                }
                return this.computeNext();
            }
            return null;
        }

        protected boolean check(Substitution s) {
            for (Atom a : ComplexHomomorphism.this.builtInAtoms) {
                Atom a2 = s.createImageOf(a);
                if (((BuiltInPredicate)a2.getPredicate()).evaluate(a2.getTerms().toArray(new Term[a2.getTerms().size()]))) continue;
                return false;
            }
            return true;
        }

        public void remove() {
        }

        public Iterator<Substitution> iterator() {
            return this;
        }

        public void close() {
            this.rawReader.close();
            this.rawReader = null;
        }
    }
}

