/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.graal.homomorphism;

import fr.lirmm.graphik.graal.api.core.AtomSet;
import fr.lirmm.graphik.graal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.graal.api.core.Query;
import fr.lirmm.graphik.graal.api.homomorphism.Homomorphism;
import fr.lirmm.graphik.graal.api.homomorphism.HomomorphismChecker;
import fr.lirmm.graphik.graal.api.homomorphism.HomomorphismFactory;
import fr.lirmm.graphik.graal.core.factory.ConjunctiveQueryFactory;
import fr.lirmm.graphik.graal.homomorphism.checker.DefaultUnionConjunctiveQueriesChecker;
import fr.lirmm.graphik.graal.homomorphism.checker.RecursiveBacktrackChecker;
import java.util.SortedSet;
import java.util.TreeSet;

public final class DefaultHomomorphismFactory
implements HomomorphismFactory {
    private SortedSet<HomomorphismChecker> elements = new TreeSet<HomomorphismChecker>();
    private static DefaultHomomorphismFactory instance = null;
    private static ConjunctiveQuery emptyConjunctiveQuery = ConjunctiveQueryFactory.instance().create();

    private DefaultHomomorphismFactory() {
        this.elements.add((HomomorphismChecker)new RecursiveBacktrackChecker());
        this.elements.add((HomomorphismChecker)new DefaultUnionConjunctiveQueriesChecker());
    }

    public static final synchronized DefaultHomomorphismFactory instance() {
        if (instance == null) {
            instance = new DefaultHomomorphismFactory();
        }
        return instance;
    }

    public boolean addChecker(HomomorphismChecker checker) {
        return this.elements.add(checker);
    }

    public Homomorphism<? extends Query, ? extends AtomSet> getConjunctiveQuerySolver(AtomSet atomset) {
        Homomorphism solver = null;
        for (HomomorphismChecker e : this.elements) {
            if (!e.check((Query)emptyConjunctiveQuery, atomset)) continue;
            solver = e.getSolver();
            break;
        }
        return solver;
    }

    public Homomorphism<? extends Query, ? extends AtomSet> getSolver(Query query, AtomSet atomset) {
        Homomorphism solver = null;
        for (HomomorphismChecker e : this.elements) {
            if (!e.check(query, atomset)) continue;
            solver = e.getSolver();
            break;
        }
        return solver;
    }
}

