/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.graal.homomorphism;

import fr.lirmm.graphik.graal.api.core.Atom;
import fr.lirmm.graphik.graal.api.core.AtomSet;
import fr.lirmm.graphik.graal.api.core.Term;
import fr.lirmm.graphik.graal.api.core.stream.SubstitutionReader;
import fr.lirmm.graphik.graal.api.homomorphism.HomomorphismException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PureHomomorphism
implements fr.lirmm.graphik.graal.api.homomorphism.Homomorphism<AtomSet, AtomSet> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PureHomomorphism.class);
    private static PureHomomorphism instance;

    protected PureHomomorphism() {
    }

    public static synchronized PureHomomorphism instance() {
        if (instance == null) {
            instance = new PureHomomorphism();
        }
        return instance;
    }

    public SubstitutionReader execute(AtomSet source, AtomSet target) throws HomomorphismException {
        return null;
    }

    public boolean exist(AtomSet source, AtomSet target) throws HomomorphismException {
        Homomorphism homomorphism = new Homomorphism();
        if (source == null || !source.iterator().hasNext()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Empty query");
            }
            return true;
        }
        if (!this.initialiseHomomorphism(homomorphism, (Iterable<Atom>)source, (Iterable<Atom>)target)) {
            return false;
        }
        return PureHomomorphism.backtrack(homomorphism);
    }

    protected boolean initialiseHomomorphism(Homomorphism homomorphism, Iterable<Atom> source, Iterable<Atom> target) {
        homomorphism.sourceAtoms = new ArrayList();
        homomorphism.firstOccurence = PureHomomorphism.computeFirstOccurence(source, homomorphism.sourceAtoms);
        int size = homomorphism.sourceAtoms.size();
        homomorphism.availableImage = new ArrayList(size);
        homomorphism.currentImages = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            homomorphism.currentImages.add(-1);
            homomorphism.availableImage.add(null);
        }
        return this.initialiseAvailableImage(homomorphism, target);
    }

    protected static boolean backtrack(Homomorphism homomorphism) {
        int level = 0;
        while (level >= 0 && level < homomorphism.sourceAtoms.size()) {
            boolean hasNextImage = PureHomomorphism.chooseNextImage(level, homomorphism);
            if (hasNextImage) {
                boolean foundImage = PureHomomorphism.checkCurrentImage(level, homomorphism);
                if (!foundImage) continue;
                ++level;
                continue;
            }
            --level;
        }
        return level >= 0;
    }

    protected static ArrayList<LinkedList<Term>> computeFirstOccurence(Iterable<Atom> source, ArrayList<Atom> sourceAtoms) {
        ArrayList<LinkedList<Term>> firstOccurenceArray = new ArrayList<LinkedList<Term>>();
        TreeSet<Term> alreadySeen = new TreeSet<Term>();
        for (Atom a : source) {
            sourceAtoms.add(a);
            LinkedList<Term> firstOccurence = new LinkedList<Term>();
            firstOccurenceArray.add(firstOccurence);
            for (Term t : a.getTerms()) {
                if (!alreadySeen.add(t)) continue;
                firstOccurence.add(t);
            }
        }
        return firstOccurenceArray;
    }

    protected static Atom getImage(int level, Homomorphism homomorphism) {
        Integer numCurrentImage = homomorphism.currentImages.get(level);
        LinkedList<Atom> images = homomorphism.availableImage.get(level);
        return images.get(numCurrentImage);
    }

    protected static boolean checkCurrentImage(int level, Homomorphism homomorphism) {
        Atom atom = homomorphism.sourceAtoms.get(level);
        Atom image = PureHomomorphism.getImage(level, homomorphism);
        List sourceTerms = atom.getTerms();
        List targetTerms = image.getTerms();
        for (int i = 0; i < atom.getPredicate().getArity(); ++i) {
            Term currentImage = homomorphism.currentSubstitution.get(sourceTerms.get(i));
            if (currentImage != null && !currentImage.equals(targetTerms.get(i)) || ((Term)sourceTerms.get(i)).isConstant() && !((Term)sourceTerms.get(i)).equals(targetTerms.get(i))) {
                PureHomomorphism.resetSubstitution(level, homomorphism);
                return false;
            }
            homomorphism.currentSubstitution.put((Term)sourceTerms.get(i), (Term)targetTerms.get(i));
        }
        return true;
    }

    protected static boolean chooseNextImage(int level, Homomorphism homomorphism) {
        Integer numCurrentImage = homomorphism.currentImages.get(level);
        if (numCurrentImage != null) {
            PureHomomorphism.resetSubstitution(level, homomorphism);
            Integer n = numCurrentImage;
            Integer n2 = numCurrentImage = Integer.valueOf(numCurrentImage + 1);
        } else {
            numCurrentImage = 0;
        }
        if (numCurrentImage < homomorphism.availableImage.get(level).size()) {
            homomorphism.currentImages.set(level, numCurrentImage);
            return true;
        }
        homomorphism.currentImages.set(level, -1);
        return false;
    }

    protected static void resetSubstitution(int level, Homomorphism homomorphism) {
        for (Term t : homomorphism.firstOccurence.get(level)) {
            homomorphism.currentSubstitution.put(t, null);
        }
    }

    protected boolean initialiseAvailableImage(Homomorphism homomorphism, Iterable<Atom> target) {
        for (int i = 0; i < homomorphism.sourceAtoms.size(); ++i) {
            LinkedList<Atom> images = new LinkedList<Atom>();
            for (Atom im : target) {
                if (!this.isMappable(homomorphism.sourceAtoms.get(i), im, homomorphism)) continue;
                images.add(im);
            }
            if (images.isEmpty()) {
                return false;
            }
            homomorphism.availableImage.set(i, images);
        }
        return true;
    }

    protected boolean isMappable(Atom a, Atom im, Homomorphism homomorphism) {
        return a.getPredicate().equals((Object)im.getPredicate());
    }

    protected static class Homomorphism {
        ArrayList<Atom> sourceAtoms;
        ArrayList<LinkedList<Term>> firstOccurence;
        ArrayList<LinkedList<Atom>> availableImage;
        ArrayList<Integer> currentImages;
        Map<Term, Term> currentSubstitution = new TreeMap<Term, Term>();

        protected Homomorphism() {
        }
    }
}

