/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.graal.homomorphism;

import fr.lirmm.graphik.graal.api.core.Atom;
import fr.lirmm.graphik.graal.api.core.AtomSet;
import fr.lirmm.graphik.graal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.graal.api.core.Substitution;
import fr.lirmm.graphik.graal.api.core.Term;
import fr.lirmm.graphik.graal.api.core.stream.SubstitutionReader;
import fr.lirmm.graphik.graal.api.homomorphism.Homomorphism;
import fr.lirmm.graphik.graal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.graal.core.HashMapSubstitution;
import fr.lirmm.graphik.graal.core.stream.IteratorSubstitutionReader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecursiveBacktrackHomomorphism
implements Homomorphism<ConjunctiveQuery, AtomSet> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecursiveBacktrackHomomorphism.class);
    private static RecursiveBacktrackHomomorphism instance;
    private Set<Term> domain;

    private RecursiveBacktrackHomomorphism() {
    }

    public static synchronized RecursiveBacktrackHomomorphism instance() {
        if (instance == null) {
            instance = new RecursiveBacktrackHomomorphism();
        }
        return instance;
    }

    public SubstitutionReader execute(ConjunctiveQuery query, AtomSet facts) throws HomomorphismException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(query.toString());
        }
        List<Term> orderedVars = RecursiveBacktrackHomomorphism.order(query.getAtomSet().getTerms(Term.Type.VARIABLE));
        Collection<Atom>[] queryAtomRanked = RecursiveBacktrackHomomorphism.getAtomRank((Iterable<Atom>)query.getAtomSet(), orderedVars);
        try {
            this.domain = facts.getTerms();
            if (RecursiveBacktrackHomomorphism.isHomomorphism(queryAtomRanked[0], facts, (Substitution)new HashMapSubstitution())) {
                return new IteratorSubstitutionReader(this.homomorphism(query, queryAtomRanked, facts, (Substitution)new HashMapSubstitution(), orderedVars, 1).iterator());
            }
            return new IteratorSubstitutionReader(new LinkedList().iterator());
        }
        catch (Exception e) {
            throw new HomomorphismException(e.getMessage(), e);
        }
    }

    public boolean exist(AtomSet atomSet1, AtomSet atomSet2) throws HomomorphismException {
        try {
            List<Term> orderedVars = RecursiveBacktrackHomomorphism.order(atomSet1.getTerms(Term.Type.VARIABLE));
            Collection<Atom>[] queryAtomRanked = RecursiveBacktrackHomomorphism.getAtomRank((Iterable<Atom>)atomSet1, orderedVars);
            if (RecursiveBacktrackHomomorphism.isHomomorphism(queryAtomRanked[0], atomSet2, (Substitution)new HashMapSubstitution())) {
                return RecursiveBacktrackHomomorphism.existHomomorphism(atomSet1, queryAtomRanked, atomSet2, (Substitution)new HashMapSubstitution(), orderedVars, 1);
            }
            return false;
        }
        catch (Exception e) {
            throw new HomomorphismException(e.getMessage(), e);
        }
    }

    private Collection<Substitution> homomorphism(ConjunctiveQuery query, Collection<Atom>[] queryAtomRanked, AtomSet facts, Substitution substitution, List<Term> orderedVars, int rank) throws Exception {
        LinkedList<Substitution> substitutionList = new LinkedList<Substitution>();
        if (orderedVars.size() == 0) {
            HashMapSubstitution filteredSub = new HashMapSubstitution();
            for (Term var : query.getAnswerVariables()) {
                filteredSub.put(var, substitution.createImageOf(var));
            }
            substitutionList.add((Substitution)filteredSub);
        } else {
            Term var = orderedVars.remove(0);
            for (Term substitut : this.domain) {
                HashMapSubstitution tmpSubstitution = new HashMapSubstitution(substitution);
                tmpSubstitution.put(var, substitut);
                if (!RecursiveBacktrackHomomorphism.isHomomorphism(queryAtomRanked[rank], facts, (Substitution)tmpSubstitution)) continue;
                substitutionList.addAll(this.homomorphism(query, queryAtomRanked, facts, (Substitution)tmpSubstitution, new LinkedList<Term>(orderedVars), rank + 1));
            }
        }
        return substitutionList;
    }

    private static boolean existHomomorphism(AtomSet atomSet1, Collection<Atom>[] queryAtomRanked, AtomSet atomSet2, Substitution substitution, List<Term> orderedVars, int rank) throws Exception {
        if (orderedVars.size() == 0) {
            return true;
        }
        Set domaine = atomSet2.getTerms();
        Term var = orderedVars.remove(0);
        for (Term substitut : domaine) {
            HashMapSubstitution tmpSubstitution = new HashMapSubstitution(substitution);
            tmpSubstitution.put(var, substitut);
            if (!RecursiveBacktrackHomomorphism.isHomomorphism(queryAtomRanked[rank], atomSet2, (Substitution)tmpSubstitution) || !RecursiveBacktrackHomomorphism.existHomomorphism(atomSet1, queryAtomRanked, atomSet2, (Substitution)tmpSubstitution, new LinkedList<Term>(orderedVars), rank + 1)) continue;
            return true;
        }
        return false;
    }

    private static boolean isHomomorphism(Collection<Atom> atomsFrom, AtomSet atomsTo, Substitution substitution) throws Exception {
        for (Atom atom : atomsFrom) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("contains? " + substitution.createImageOf(atom));
            }
            if (atomsTo.contains(substitution.createImageOf(atom))) continue;
            return false;
        }
        return true;
    }

    private static List<Term> order(Collection<Term> vars) {
        LinkedList<Term> orderedList = new LinkedList<Term>();
        for (Term var : vars) {
            if (orderedList.contains(var)) continue;
            orderedList.add(var);
        }
        return orderedList;
    }

    private static Collection<Atom>[] getAtomRank(Iterable<Atom> atomset, List<Term> varsOrdered) {
        LinkedList[] atomRank = new LinkedList[varsOrdered.size() + 1];
        for (int i = 0; i < atomRank.length; ++i) {
            atomRank[i] = new LinkedList();
        }
        for (Atom a : atomset) {
            int rank = 0;
            for (Term t : a.getTerms()) {
                int tmp = varsOrdered.indexOf(t) + 1;
                if (rank >= tmp) continue;
                rank = tmp;
            }
            atomRank[rank].add(a);
        }
        return atomRank;
    }
}

