/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.graal.homomorphism;

import fr.lirmm.graphik.graal.api.core.AtomSet;
import fr.lirmm.graphik.graal.api.core.Query;
import fr.lirmm.graphik.graal.api.core.stream.SubstitutionReader;
import fr.lirmm.graphik.graal.api.homomorphism.Homomorphism;
import fr.lirmm.graphik.graal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.graal.api.homomorphism.HomomorphismFactory;
import fr.lirmm.graphik.graal.api.homomorphism.HomomorphismFactoryException;
import fr.lirmm.graphik.graal.homomorphism.DefaultHomomorphismFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticHomomorphism {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticHomomorphism.class);

    public static HomomorphismFactory getSolverFactory() {
        return DefaultHomomorphismFactory.instance();
    }

    public static SubstitutionReader executeQuery(Query query, AtomSet atomSet) throws HomomorphismFactoryException, HomomorphismException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Query : " + query);
        }
        Homomorphism<? extends Query, ? extends AtomSet> solver = DefaultHomomorphismFactory.instance().getSolver(query, atomSet);
        return solver.execute((Object)query, atomSet);
    }
}

