/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.graal.homomorphism;

import fr.lirmm.graphik.graal.api.core.AtomSet;
import fr.lirmm.graphik.graal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.graal.api.core.Query;
import fr.lirmm.graphik.graal.api.core.Substitution;
import fr.lirmm.graphik.graal.api.core.stream.SubstitutionReader;
import fr.lirmm.graphik.graal.api.homomorphism.Homomorphism;
import fr.lirmm.graphik.graal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.graal.core.UnionConjunctiveQueries;
import fr.lirmm.graphik.graal.homomorphism.DefaultHomomorphismFactory;
import java.util.Iterator;

public class UnionConjunctiveQueriesSubstitutionReader
implements SubstitutionReader {
    private AtomSet atomSet;
    private Iterator<ConjunctiveQuery> cqueryIterator;
    private SubstitutionReader tmpReader;
    private boolean hasNextCallDone = false;

    public UnionConjunctiveQueriesSubstitutionReader(UnionConjunctiveQueries queries, AtomSet atomSet) {
        this.cqueryIterator = queries.iterator();
        this.atomSet = atomSet;
        this.tmpReader = null;
    }

    public boolean hasNext() {
        if (!this.hasNextCallDone) {
            this.hasNextCallDone = true;
            while ((this.tmpReader == null || !this.tmpReader.hasNext()) && this.cqueryIterator.hasNext()) {
                Query q = (Query)this.cqueryIterator.next();
                try {
                    Homomorphism<? extends Query, ? extends AtomSet> solver = DefaultHomomorphismFactory.instance().getSolver(q, this.atomSet);
                    if (solver == null) {
                        return false;
                    }
                    this.tmpReader = solver.execute((Object)q, this.atomSet);
                }
                catch (HomomorphismException e) {
                    return false;
                }
            }
        }
        return this.tmpReader != null && this.tmpReader.hasNext();
    }

    public Substitution next() {
        if (!this.hasNextCallDone) {
            this.hasNext();
        }
        this.hasNextCallDone = false;
        return this.tmpReader.next();
    }

    public Iterator<Substitution> iterator() {
        return this;
    }

    public void close() {
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

