/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.api.core;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.Constant;
import fr.lirmm.graphik.integraal.api.core.Literal;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.TermGenerator;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.util.stream.CloseableIterable;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;
import fr.lirmm.graphik.util.stream.Iterators;
import fr.lirmm.graphik.util.stream.filter.Filter;
import fr.lirmm.graphik.util.stream.filter.FilterIterator;
import java.util.Set;

public interface AtomSet
extends CloseableIterable<Atom> {
    public boolean contains(Atom var1) throws AtomSetException;

    public CloseableIterator<Atom> match(Atom var1) throws AtomSetException;

    public CloseableIterator<Atom> match(Atom var1, Substitution var2) throws AtomSetException;

    public CloseableIterator<Atom> atomsByPredicate(Predicate var1) throws AtomSetException;

    default public CloseableIterator<Atom> atomsByTerm(final Term term) throws AtomSetException {
        if (!this.getTerms().contains(term)) {
            return Iterators.emptyIterator();
        }
        return new FilterIterator(this.iterator(), new Filter<Atom>(){

            @Override
            public boolean filter(Atom a) {
                return a.contains(term);
            }
        });
    }

    public CloseableIterator<Term> termsByPredicatePosition(Predicate var1, int var2) throws AtomSetException;

    public Set<Predicate> getPredicates() throws AtomSetException;

    public CloseableIterator<Predicate> predicatesIterator() throws AtomSetException;

    public Set<Term> getTerms() throws AtomSetException;

    public Set<Variable> getVariables() throws AtomSetException;

    public Set<Constant> getConstants() throws AtomSetException;

    public Set<Literal> getLiterals() throws AtomSetException;

    @Deprecated
    public Set<Term> getTerms(Term.Type var1) throws AtomSetException;

    public CloseableIterator<Term> termsIterator() throws AtomSetException;

    public CloseableIterator<Variable> variablesIterator() throws AtomSetException;

    public CloseableIterator<Constant> constantsIterator() throws AtomSetException;

    public CloseableIterator<Literal> literalsIterator() throws AtomSetException;

    @Deprecated
    public CloseableIterator<Term> termsIterator(Term.Type var1) throws AtomSetException;

    @Deprecated
    public boolean isSubSetOf(AtomSet var1) throws AtomSetException;

    public int size() throws AtomSetException;

    public boolean isEmpty() throws AtomSetException;

    public boolean add(Atom var1) throws AtomSetException;

    public boolean addAll(CloseableIterator<? extends Atom> var1) throws AtomSetException;

    public boolean addAll(AtomSet var1) throws AtomSetException;

    public boolean remove(Atom var1) throws AtomSetException;

    default public void removeWithoutCheck(Atom atom) throws AtomSetException {
        this.remove(atom);
    }

    public boolean removeAll(CloseableIterator<? extends Atom> var1) throws AtomSetException;

    public boolean removeAll(AtomSet var1) throws AtomSetException;

    public void clear() throws AtomSetException;

    @Override
    public CloseableIterator<Atom> iterator();

    public TermGenerator getFreshSymbolGenerator();

    default public boolean containsTerm(Term t) throws AtomSetException {
        CloseableIterator<Term> it = this.termsIterator();
        try {
            while (it.hasNext()) {
                if (!it.next().equals(t)) continue;
                it.close();
                return true;
            }
        }
        catch (IteratorException e) {
            throw new AtomSetException(e);
        }
        return false;
    }
}

