/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.api.io;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.integraal.api.core.NegativeConstraint;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.factory.AtomFactory;
import fr.lirmm.graphik.integraal.api.io.AbstractWriter;
import fr.lirmm.graphik.integraal.api.io.GraalWriter;
import fr.lirmm.graphik.util.Prefix;
import fr.lirmm.graphik.util.stream.CloseableIterable;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public abstract class AbstractGraalWriter
extends AbstractWriter
implements GraalWriter {
    private AtomFactory atomFactory;

    protected AbstractGraalWriter(Writer out, AtomFactory atomFactory) {
        super(out);
        this.atomFactory = atomFactory;
    }

    @Override
    public abstract AbstractGraalWriter writeComment(String var1) throws IOException;

    @Override
    public AbstractGraalWriter write(Object o) throws IOException {
        if (o instanceof Atom) {
            this.write((Atom)o);
        } else if (o instanceof NegativeConstraint) {
            this.write((NegativeConstraint)o);
        } else if (o instanceof Rule) {
            this.write((Rule)o);
        } else if (o instanceof ConjunctiveQuery) {
            this.write((ConjunctiveQuery)o);
        } else if (o instanceof Prefix) {
            this.write((Prefix)o);
        } else if (o instanceof String) {
            this.write((String)o);
        } else if (o instanceof AtomSet) {
            this.write((AtomSet)o);
        } else if (o instanceof Iterable) {
            this.writeIterable((Iterable)o);
        } else if (o instanceof Iterator) {
            this.writeIterator((Iterator)o);
        } else if (o instanceof CloseableIterable) {
            this.writeCloseableIterable((CloseableIterable)o);
        } else if (o instanceof CloseableIterator) {
            this.writeCloseableIterator((CloseableIterator)o);
        } else {
            this.writeln(o.toString());
        }
        return this;
    }

    @Override
    public AbstractGraalWriter write(Object ... objects) throws IOException {
        for (Object o : objects) {
            this.write(o);
        }
        return this;
    }

    protected void writeIterable(Iterable<?> it) throws IOException {
        for (Object o : it) {
            this.write(o);
        }
    }

    protected void writeIterator(Iterator<?> it) throws IOException {
        while (it.hasNext()) {
            this.write(it.next());
        }
    }

    protected void writeCloseableIterable(CloseableIterable<?> it) throws IOException {
        this.writeCloseableIterator(it.iterator());
    }

    protected void writeCloseableIterator(CloseableIterator<?> it) throws IOException {
        while (it.hasNext()) {
            this.write(it.next());
        }
    }

    protected final void writeAtom(Atom atom) throws IOException {
        if (atom.equals(this.atomFactory.getBottom())) {
            this.writeBottom();
        } else if (atom.getPredicate().equals(Predicate.EQUALITY)) {
            this.writeEquality(atom.getTerm(0), atom.getTerm(1));
        } else {
            this.writeStandardAtom(atom);
        }
    }

    protected abstract void writeStandardAtom(Atom var1) throws IOException;

    protected abstract void writeEquality(Term var1, Term var2) throws IOException;

    protected abstract void writeBottom() throws IOException;
}

