/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.core.DefaultAtom;
import fr.lirmm.graphik.integraal.core.factory.DefaultAtomSetFactory;
import fr.lirmm.graphik.integraal.core.factory.DefaultConjunctiveQueryFactory;
import fr.lirmm.graphik.integraal.core.factory.DefaultRuleFactory;
import fr.lirmm.graphik.integraal.core.factory.DefaultSubstitutionFactory;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class AbstractSubstitution
implements Substitution {
    @Override
    public List<Term> createImageOf(Collection<? extends Term> terms) {
        ArrayList<Term> l = new ArrayList<Term>(terms.size());
        for (Term term : terms) {
            l.add(this.createImageOf(term));
        }
        return l;
    }

    @Override
    public boolean put(Substitution substitution) {
        for (Variable term : substitution.getTerms()) {
            if (this.put(term, substitution.createImageOf(term))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Atom createImageOf(Atom atom) {
        List<Term> terms = atom.getTerms();
        Term[] termsSubstitut = new Term[terms.size()];
        int i = -1;
        for (Term term : atom) {
            termsSubstitut[++i] = this.createImageOf(term);
        }
        return new DefaultAtom(atom.getPredicate(), termsSubstitut);
    }

    @Override
    public InMemoryAtomSet createImageOf(AtomSet src) throws AtomSetException {
        InMemoryAtomSet dest = DefaultAtomSetFactory.instance().create();
        this.apply(src, (AtomSet)dest);
        return dest;
    }

    @Override
    public InMemoryAtomSet createImageOf(InMemoryAtomSet src) {
        InMemoryAtomSet dest = DefaultAtomSetFactory.instance().create();
        this.apply(src, dest);
        return dest;
    }

    @Override
    public void apply(AtomSet src, AtomSet dest) throws AtomSetException {
        CloseableIterator<Atom> it = src.iterator();
        try {
            while (it.hasNext()) {
                Atom a = it.next();
                dest.add(this.createImageOf(a));
            }
        }
        catch (IteratorException e) {
            throw new AtomSetException("Error during the iteration over src", e);
        }
    }

    @Override
    public void apply(InMemoryAtomSet src, InMemoryAtomSet dest) {
        for (Atom a : src) {
            dest.add(this.createImageOf(a));
        }
    }

    @Override
    public Rule createImageOf(Rule rule) {
        Rule substitut = DefaultRuleFactory.instance().create();
        this.apply(rule.getBody(), substitut.getBody());
        this.apply(rule.getHead(), substitut.getHead());
        return substitut;
    }

    @Override
    public ConjunctiveQuery createImageOf(ConjunctiveQuery cq) {
        List<Term> ans = this.createImageOf(cq.getAnswerVariables());
        InMemoryAtomSet body = this.createImageOf(cq.getAtomSet());
        return DefaultConjunctiveQueryFactory.instance().create(body, ans);
    }

    @Override
    public boolean compose(Variable term, Term substitut) {
        substitut = this.createImageOf(substitut);
        return this.put(term, substitut);
    }

    @Override
    public Substitution compose(Substitution s) {
        Substitution newSub = DefaultSubstitutionFactory.instance().createSubstitution(this);
        for (Variable term : s.getTerms()) {
            if (newSub.compose(term, s.createImageOf(term))) continue;
            return null;
        }
        return newSub;
    }

    @Override
    public Substitution aggregate(Substitution s) {
        Substitution newSub = DefaultSubstitutionFactory.instance().createSubstitution(this);
        for (Variable term : s.getTerms()) {
            if (newSub.aggregate(term, s.createImageOf(term))) continue;
            return null;
        }
        return newSub;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }

    @Override
    public void appendTo(StringBuilder sb) {
        boolean first = true;
        sb.append('{');
        for (Term term : this.getTerms()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(term).append("->");
            sb.append(this.createImageOf(term));
        }
        sb.append('}');
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Substitution)) {
            return false;
        }
        return this.equals((Substitution)obj);
    }

    public boolean equals(Substitution other) {
        if (!this.getTerms().equals(other.getTerms()) || !this.getValues().equals(other.getValues())) {
            return false;
        }
        for (Variable v : this.getTerms()) {
            if (this.createImageOf(v).equals(other.createImageOf(v))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Substitution other) {
        Set<Variable> set = this.getTerms();
        Set<Variable> otherset = other.getTerms();
        if (set.size() != otherset.size()) {
            return set.size() - otherset.size();
        }
        for (Term term : set) {
            int val = this.createImageOf(term).compareTo(other.createImageOf(term));
            if (val == 0) continue;
            return val;
        }
        return 0;
    }

    public int hashCode() {
        return (this.getTerms().hashCode() << 16) + this.getValues().hashCode();
    }
}

