/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core;

import fr.lirmm.graphik.integraal.api.core.AbstractAtom;
import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Constant;
import fr.lirmm.graphik.integraal.api.core.Literal;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.util.ArrayIterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public class DefaultAtom
extends AbstractAtom
implements Serializable {
    private static final long serialVersionUID = -5889218407173357933L;
    private Predicate predicate;
    private Term[] terms;

    public DefaultAtom(Predicate predicate) {
        this.predicate = predicate;
        int n = predicate.getArity();
        this.terms = new Term[n];
    }

    public DefaultAtom(Predicate predicate, List<Term> terms) {
        this.predicate = predicate;
        int n = predicate.getArity();
        this.terms = new Term[n];
        int i = 0;
        for (Term t : terms) {
            this.terms[i++] = t;
            if (i != n) continue;
            break;
        }
    }

    public DefaultAtom(Predicate predicate, Term ... terms) {
        this.predicate = predicate;
        this.terms = terms;
    }

    public DefaultAtom(Atom atom) {
        this(atom.getPredicate(), atom.getTerms());
    }

    @Override
    @Deprecated
    public Collection<Term> getTerms(Term.Type type) {
        LinkedList<Term> typedTerms = new LinkedList<Term>();
        for (Term term : this.terms) {
            if (!type.equals((Object)term.getType())) continue;
            typedTerms.add(term);
        }
        return typedTerms;
    }

    @Override
    public Set<Constant> getConstants() {
        HashSet<Constant> typedTerms = new HashSet<Constant>();
        for (Term term : this.terms) {
            if (!term.isConstant()) continue;
            typedTerms.add((Constant)term);
        }
        return typedTerms;
    }

    @Override
    public Set<Variable> getVariables() {
        HashSet<Variable> typedTerms = new HashSet<Variable>();
        for (Term term : this.terms) {
            if (!term.isVariable()) continue;
            typedTerms.add((Variable)term);
        }
        return typedTerms;
    }

    @Override
    public Set<Literal> getLiterals() {
        HashSet<Literal> typedTerms = new HashSet<Literal>();
        for (Term term : this.terms) {
            if (!term.isLiteral()) continue;
            typedTerms.add((Literal)term);
        }
        return typedTerms;
    }

    @Override
    public boolean contains(Term term) {
        return this.indexOf(term) >= 0;
    }

    @Override
    public int indexOf(Term t) {
        return ArrayUtils.indexOf((Object[])this.terms, (Object)t);
    }

    @Override
    public int[] indexesOf(Term term) {
        int[] result = null;
        int resultCounter = 0;
        int termsSize = this.terms.length;
        for (int i = 0; i < termsSize; ++i) {
            if (!this.terms[i].equals(term)) continue;
            ++resultCounter;
        }
        result = new int[resultCounter];
        if (resultCounter != 0) {
            int pos = 0;
            for (int i = 0; i < termsSize; ++i) {
                if (!this.terms[i].equals(term)) continue;
                result[pos] = i;
                ++pos;
            }
        }
        return result;
    }

    @Override
    public void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public void setTerm(int index, Term term) {
        this.terms[index] = term;
    }

    @Override
    public Term getTerm(int index) {
        return this.terms[index];
    }

    public void setTerms(List<Term> terms) {
        int i = 0;
        for (Term t : terms) {
            this.terms[i++] = t;
            if (i != this.terms.length) continue;
            break;
        }
    }

    @Override
    public List<Term> getTerms() {
        return Arrays.asList(this.terms);
    }

    @Override
    public Iterator<Term> iterator() {
        return new ArrayIterator<Term>(this.terms);
    }
}

