/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.core.factory.DefaultAtomSetFactory;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorWithoutException;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.LinkedList;
import java.util.List;

public class DefaultConjunctiveQuery
implements ConjunctiveQuery {
    private String label;
    private InMemoryAtomSet atomSet;
    private List<Term> responseVariables;

    public DefaultConjunctiveQuery() {
        this.label = "";
        this.atomSet = DefaultAtomSetFactory.instance().create();
        this.responseVariables = new LinkedList<Term>();
    }

    public DefaultConjunctiveQuery(InMemoryAtomSet atomSet) {
        this.label = "";
        this.atomSet = atomSet;
        this.responseVariables = new LinkedList<Variable>(atomSet.getVariables());
    }

    public DefaultConjunctiveQuery(InMemoryAtomSet atomSet, List<Term> ans) {
        this("", atomSet, ans);
    }

    public DefaultConjunctiveQuery(CloseableIterator<Atom> atomSet, CloseableIterator<Term> answerVariables) throws IteratorException {
        this.label = "";
        this.atomSet = DefaultAtomSetFactory.instance().create(atomSet);
        this.responseVariables = new LinkedList<Term>();
        while (answerVariables.hasNext()) {
            this.responseVariables.add(answerVariables.next());
        }
    }

    public DefaultConjunctiveQuery(CloseableIteratorWithoutException<Atom> atomSet, CloseableIteratorWithoutException<Term> answerVariables) {
        this.label = "";
        this.atomSet = DefaultAtomSetFactory.instance().create(atomSet);
        this.responseVariables = new LinkedList<Term>();
        while (answerVariables.hasNext()) {
            this.responseVariables.add(answerVariables.next());
        }
    }

    public DefaultConjunctiveQuery(String label, InMemoryAtomSet atomSet, List<Term> ans) {
        this.label = label;
        this.atomSet = atomSet;
        this.responseVariables = ans;
    }

    public DefaultConjunctiveQuery(ConjunctiveQuery query) {
        this.label = query.getLabel();
        this.atomSet = DefaultAtomSetFactory.instance().create(query.getAtomSet());
        this.responseVariables = new LinkedList<Term>(query.getAnswerVariables());
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public InMemoryAtomSet getAtomSet() {
        return this.atomSet;
    }

    public void setAtomSet(InMemoryAtomSet atomSet) {
        this.atomSet = atomSet;
    }

    @Override
    public List<Term> getAnswerVariables() {
        return this.responseVariables;
    }

    @Override
    public void setAnswerVariables(List<Term> v) {
        this.responseVariables = v;
    }

    @Override
    public boolean isBoolean() {
        return this.responseVariables.isEmpty();
    }

    @Override
    public CloseableIteratorWithoutException<Atom> iterator() {
        return this.getAtomSet().iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }

    @Override
    public void appendTo(StringBuilder sb) {
        sb.append("ANS(");
        boolean first = true;
        for (Term t : this.responseVariables) {
            if (!first) {
                sb.append(',');
            }
            first = false;
            sb.append(t);
        }
        sb.append(") : ");
        sb.append(this.atomSet);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConjunctiveQuery)) {
            return false;
        }
        ConjunctiveQuery other = (ConjunctiveQuery)obj;
        return this.equals(other);
    }

    public boolean equals(ConjunctiveQuery other) {
        return this.getAnswerVariables().equals(other.getAnswerVariables()) && this.getAtomSet().equals(other.getAtomSet());
    }
}

