/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core;

import fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.integraal.api.core.EffectiveConjunctiveQuery;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.UnionOfConjunctiveQueries;
import fr.lirmm.graphik.integraal.core.DefaultEffectiveConjunctiveQuery;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import fr.lirmm.graphik.util.stream.CloseableIteratorWithoutException;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class DefaultUnionOfConjunctiveQueries
implements UnionOfConjunctiveQueries {
    private String label = "";
    private Collection<EffectiveConjunctiveQuery> queries;
    private List<Term> ans;

    public DefaultUnionOfConjunctiveQueries(List<Term> ans, Collection<ConjunctiveQuery> queries) {
        this.ans = ans;
        this.queries = new LinkedList<EffectiveConjunctiveQuery>();
        for (ConjunctiveQuery cq : queries) {
            this.queries.add(new DefaultEffectiveConjunctiveQuery(cq, null));
        }
    }

    public DefaultUnionOfConjunctiveQueries(List<Term> ans, CloseableIteratorWithoutException<EffectiveConjunctiveQuery> queries) {
        this.ans = ans;
        this.queries = new LinkedList<EffectiveConjunctiveQuery>();
        while (queries.hasNext()) {
            this.queries.add(queries.next());
        }
        queries.close();
    }

    public DefaultUnionOfConjunctiveQueries(List<Term> ans, CloseableIterator<EffectiveConjunctiveQuery> queries) throws IteratorException {
        this.ans = ans;
        this.queries = new LinkedList<EffectiveConjunctiveQuery>();
        while (queries.hasNext()) {
            this.queries.add(queries.next());
        }
        queries.close();
    }

    public DefaultUnionOfConjunctiveQueries(List<Term> ans, ConjunctiveQuery ... queries) {
        this.ans = ans;
        this.queries = new LinkedList<EffectiveConjunctiveQuery>();
        for (ConjunctiveQuery cq : queries) {
            this.queries.add(new DefaultEffectiveConjunctiveQuery(cq, null));
        }
    }

    @Override
    public List<Term> getAnswerVariables() {
        return this.ans;
    }

    @Override
    public List<ConjunctiveQuery> getConjunctiveQueries() {
        LinkedList<ConjunctiveQuery> ret = new LinkedList<ConjunctiveQuery>();
        for (EffectiveConjunctiveQuery item : this.queries) {
            ret.add((ConjunctiveQuery)item.getQuery());
        }
        return ret;
    }

    @Override
    public CloseableIteratorWithoutException<EffectiveConjunctiveQuery> iterator() {
        return new CloseableIteratorAdapter<EffectiveConjunctiveQuery>(this.queries.iterator());
    }

    @Override
    public boolean isEmpty() {
        return this.queries.isEmpty();
    }

    @Override
    public int size() {
        return this.queries.size();
    }

    @Override
    public boolean isBoolean() {
        return this.ans.isEmpty();
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }

    @Override
    public void appendTo(StringBuilder sb) {
        for (EffectiveConjunctiveQuery q : this.queries) {
            sb.append(q.getQuery());
            sb.append(q.getSubstitution());
            sb.append("\n| ");
        }
    }
}

