/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core;

import fr.lirmm.graphik.integraal.GraalConstant;
import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.core.DefaultAtom;
import fr.lirmm.graphik.integraal.core.atomset.AtomSetUtils;
import fr.lirmm.graphik.integraal.core.atomset.DefaultInMemoryAtomSet;
import fr.lirmm.graphik.integraal.core.atomset.graph.DefaultInMemoryGraphStore;
import fr.lirmm.graphik.integraal.core.atomset.splitter.PiecesSplitter;
import fr.lirmm.graphik.integraal.core.factory.DefaultAtomFactory;
import fr.lirmm.graphik.integraal.core.factory.DefaultRuleFactory;
import fr.lirmm.graphik.util.stream.CloseableIterableWithoutException;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;

public final class Rules {
    private static int auxIndex = -1;

    private Rules() {
    }

    public static boolean hasAtomicBody(Rule rule) {
        return AtomSetUtils.isSingleton(rule.getBody());
    }

    public static boolean hasAtomicHead(Rule rule) {
        return AtomSetUtils.isSingleton(rule.getHead());
    }

    public static boolean isThereOneAtomThatContainsAllVars(CloseableIterableWithoutException<Atom> atomset, Collection<Variable> terms) {
        for (Atom atom : atomset) {
            if (!atom.getVariables().containsAll(terms)) continue;
            return true;
        }
        return false;
    }

    public static Collection<InMemoryAtomSet> getPieces(Rule rule) {
        PiecesSplitter piecesSplitter = new PiecesSplitter(true, rule.getExistentials());
        try {
            return piecesSplitter.split(rule.getHead());
        }
        catch (AtomSetException | IteratorException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SinglePieceRulesIterator computeSinglePiece(Iterator<Rule> rules) {
        return new SinglePieceRulesIterator(rules);
    }

    public static Iterator<Rule> computeAtomicHead(Iterator<Rule> rules) {
        return new AtomicHeadIterator(new SinglePieceRulesIterator(rules));
    }

    public static Collection<Rule> computeSinglePiece(Rule rule) {
        String label = rule.getLabel();
        LinkedList<Rule> monoPiece = new LinkedList<Rule>();
        if (label.isEmpty()) {
            for (InMemoryAtomSet piece : Rules.getPieces(rule)) {
                monoPiece.add(DefaultRuleFactory.instance().create(rule.getBody(), piece));
            }
        } else {
            int i = -1;
            for (InMemoryAtomSet piece : Rules.getPieces(rule)) {
                monoPiece.add(DefaultRuleFactory.instance().create(label + "-p" + ++i, rule.getBody(), piece));
            }
        }
        return monoPiece;
    }

    public static Collection<Rule> computeAtomicHead(Rule rule) {
        String label = rule.getLabel();
        LinkedList<Rule> atomicHead = new LinkedList<Rule>();
        if (rule.getHead().isEmpty() || Rules.hasAtomicHead(rule)) {
            return Collections.singleton(rule);
        }
        Predicate predicate = new Predicate("aux_" + ++auxIndex, rule.getTerms().size());
        Atom aux = DefaultAtomFactory.instance().create(predicate, rule.getTerms().toArray(new Term[rule.getTerms().size()]));
        if (label.isEmpty()) {
            atomicHead.add(DefaultRuleFactory.instance().create(rule.getBody(), new DefaultInMemoryAtomSet(aux)));
            for (Atom atom : rule.getHead()) {
                atomicHead.add(DefaultRuleFactory.instance().create(aux, atom));
            }
        } else {
            int i = -1;
            atomicHead.add(DefaultRuleFactory.instance().create(label + "-a" + ++i, rule.getBody(), new DefaultInMemoryAtomSet(aux)));
            for (Atom atom : rule.getHead()) {
                atomicHead.add(DefaultRuleFactory.instance().create(label + "-a" + ++i, aux, atom));
            }
        }
        return atomicHead;
    }

    public static boolean isConcept(Atom a) {
        return a.getPredicate().getArity() == 1;
    }

    public static boolean isRole(Atom a) {
        return a.getPredicate().getArity() == 2;
    }

    public static boolean isInclusion(Rule r) {
        return Rules.hasAtomicBody(r) && Rules.hasAtomicHead(r);
    }

    public static boolean isConceptInclusion(Rule r) {
        if (!Rules.isInclusion(r)) {
            return false;
        }
        Atom C1 = (Atom)r.getBody().iterator().next();
        Atom C2 = (Atom)r.getHead().iterator().next();
        if (!Rules.isConcept(C1)) {
            return false;
        }
        if (!Rules.isConcept(C2)) {
            return false;
        }
        return C1.getTerm(0).equals(C2.getTerm(0));
    }

    public static boolean isRoleInclusion(Rule r) {
        if (!Rules.isInclusion(r)) {
            return false;
        }
        Atom P1 = (Atom)r.getBody().iterator().next();
        Atom P2 = (Atom)r.getHead().iterator().next();
        if (!Rules.isRole(P1)) {
            return false;
        }
        if (!Rules.isRole(P2)) {
            return false;
        }
        Term t1_1 = P1.getTerm(0);
        Term t1_2 = P1.getTerm(1);
        Term t2_1 = P2.getTerm(0);
        Term t2_2 = P2.getTerm(1);
        return t1_1.equals(t2_1) && t1_2.equals(t2_2) || t1_1.equals(t2_2) && t1_2.equals(t2_1);
    }

    public static boolean isInverseRole(Rule r) {
        if (!Rules.isRoleInclusion(r)) {
            return false;
        }
        Atom P1 = (Atom)r.getBody().iterator().next();
        Atom P2 = (Atom)r.getHead().iterator().next();
        Term t1_1 = P1.getTerm(0);
        Term t1_2 = P1.getTerm(1);
        Term t2_1 = P2.getTerm(0);
        Term t2_2 = P2.getTerm(1);
        return t1_1.equals(t2_2) && t1_2.equals(t2_1);
    }

    public static boolean isSignature(Rule r) {
        if (!Rules.isInclusion(r)) {
            return false;
        }
        Atom P1 = (Atom)r.getBody().iterator().next();
        Atom C1 = (Atom)r.getHead().iterator().next();
        return Rules.isRole(P1) && Rules.isConcept(C1);
    }

    public static boolean isDomain(Rule r) {
        if (!Rules.isSignature(r)) {
            return false;
        }
        Atom P1 = (Atom)r.getBody().iterator().next();
        Atom C1 = (Atom)r.getHead().iterator().next();
        return P1.getTerm(0).equals(C1.getTerm(0));
    }

    public static boolean isRange(Rule r) {
        if (!Rules.isSignature(r)) {
            return false;
        }
        Atom P1 = (Atom)r.getBody().iterator().next();
        Atom C1 = (Atom)r.getHead().iterator().next();
        return P1.getTerm(1).equals(C1.getTerm(0));
    }

    public static boolean isMandatoryRole(Rule r) {
        if (!Rules.isInclusion(r)) {
            return false;
        }
        Atom C1 = (Atom)r.getBody().iterator().next();
        Atom P1 = (Atom)r.getHead().iterator().next();
        if (!Rules.isConcept(C1)) {
            return false;
        }
        if (!Rules.isRole(P1)) {
            return false;
        }
        return C1.getTerm(0).equals(P1.getTerm(0)) && !C1.getTerm(0).equals(P1.getTerm(1));
    }

    public static boolean isInvMandatoryRole(Rule r) {
        if (!Rules.isInclusion(r)) {
            return false;
        }
        Atom C1 = (Atom)r.getBody().iterator().next();
        Atom P1 = (Atom)r.getHead().iterator().next();
        if (!Rules.isConcept(C1)) {
            return false;
        }
        if (!Rules.isRole(P1)) {
            return false;
        }
        return C1.getTerm(0).equals(P1.getTerm(1)) && !C1.getTerm(0).equals(P1.getTerm(0));
    }

    public static boolean isExistRC(Rule r) {
        if (!AtomSetUtils.isSingleton(r.getBody())) {
            return false;
        }
        if (!AtomSetUtils.hasSize2(r.getHead())) {
            return false;
        }
        CloseableIterator h = r.getHead().iterator();
        Atom P1 = (Atom)r.getBody().iterator().next();
        Atom P2 = (Atom)h.next();
        Atom P3 = (Atom)h.next();
        if (!Rules.isConcept(P1)) {
            return false;
        }
        if (Rules.isConcept(P2) && Rules.isRole(P3)) {
            Atom tmp = P2;
            P2 = P3;
            P3 = tmp;
        }
        if (!Rules.isRole(P2)) {
            return false;
        }
        if (!Rules.isConcept(P3)) {
            return false;
        }
        return P1.getTerm(0).equals(P2.getTerm(0)) && P2.getTerm(1).equals(P3.getTerm(0)) && !P1.getTerm(0).equals(P3.getTerm(0));
    }

    public static boolean isInvExistRC(Rule r) {
        if (!AtomSetUtils.isSingleton(r.getBody())) {
            return false;
        }
        if (!AtomSetUtils.hasSize2(r.getHead())) {
            return false;
        }
        CloseableIterator h = r.getHead().iterator();
        Atom P1 = (Atom)r.getBody().iterator().next();
        Atom P2 = (Atom)h.next();
        Atom P3 = (Atom)h.next();
        if (!Rules.isConcept(P1)) {
            return false;
        }
        if (Rules.isConcept(P2) && Rules.isRole(P3)) {
            Atom tmp = P2;
            P2 = P3;
            P3 = tmp;
        }
        if (!Rules.isRole(P2)) {
            return false;
        }
        if (!Rules.isConcept(P3)) {
            return false;
        }
        return P1.getTerm(0).equals(P2.getTerm(1)) && P2.getTerm(0).equals(P3.getTerm(0)) && !P1.getTerm(0).equals(P3.getTerm(0));
    }

    public static boolean isRoleComposition(Rule r) {
        if (!AtomSetUtils.hasSize2(r.getBody())) {
            return false;
        }
        if (!AtomSetUtils.isSingleton(r.getHead())) {
            return false;
        }
        CloseableIterator b = r.getBody().iterator();
        Atom P1 = (Atom)b.next();
        Atom P2 = (Atom)b.next();
        Atom P3 = (Atom)r.getHead().iterator().next();
        if (!Rules.isRole(P1)) {
            return false;
        }
        if (!Rules.isRole(P2)) {
            return false;
        }
        if (!Rules.isRole(P3)) {
            return false;
        }
        return P1.getTerm(0).equals(P3.getTerm(0)) && P1.getTerm(1).equals(P2.getTerm(0)) && P2.getTerm(1).equals(P3.getTerm(1)) || P2.getTerm(0).equals(P3.getTerm(0)) && P2.getTerm(1).equals(P1.getTerm(0)) && P1.getTerm(1).equals(P3.getTerm(1));
    }

    public static boolean isTransitivity(Rule r) {
        if (!Rules.isRoleComposition(r)) {
            return false;
        }
        CloseableIterator b = r.getBody().iterator();
        Atom P1 = (Atom)b.next();
        Atom P2 = (Atom)b.next();
        Atom P3 = (Atom)r.getHead().iterator().next();
        return P1.getPredicate().equals(P2.getPredicate()) && P1.getPredicate().equals(P3.getPredicate());
    }

    public static boolean isFunctional(Rule r) {
        if (!AtomSetUtils.isSingleton(r.getHead())) {
            return false;
        }
        return ((Atom)r.getHead().iterator().next()).getPredicate().equals(Predicate.EQUALITY);
    }

    public static boolean isNegativeConstraint(Rule r) {
        if (!AtomSetUtils.isSingleton(r.getHead())) {
            return false;
        }
        return ((Atom)r.getHead().iterator().next()).equals(DefaultAtomFactory.instance().getBottom());
    }

    public static boolean isDisjointConcept(Rule r) {
        if (!AtomSetUtils.hasSize2(r.getBody())) {
            return false;
        }
        if (!Rules.isNegativeConstraint(r)) {
            return false;
        }
        CloseableIterator b = r.getBody().iterator();
        Atom C1 = (Atom)b.next();
        Atom C2 = (Atom)b.next();
        if (!Rules.isConcept(C1)) {
            return false;
        }
        if (!Rules.isConcept(C2)) {
            return false;
        }
        return C1.getTerm(0).equals(C2.getTerm(0));
    }

    public static boolean isDisjointRole(Rule r) {
        if (!AtomSetUtils.hasSize2(r.getBody())) {
            return false;
        }
        if (!Rules.isNegativeConstraint(r)) {
            return false;
        }
        CloseableIterator b = r.getBody().iterator();
        Atom P1 = (Atom)b.next();
        Atom P2 = (Atom)b.next();
        if (!Rules.isRole(P1)) {
            return false;
        }
        if (!Rules.isRole(P2)) {
            return false;
        }
        return P1.getTerm(0).equals(P2.getTerm(0)) && P1.getTerm(1).equals(P2.getTerm(1)) || P1.getTerm(1).equals(P2.getTerm(0)) && P1.getTerm(0).equals(P2.getTerm(1));
    }

    public static boolean isDisjointInverseRole(Rule r) {
        if (!Rules.isDisjointRole(r)) {
            return false;
        }
        CloseableIterator b = r.getBody().iterator();
        Atom P1 = (Atom)b.next();
        Atom P2 = (Atom)b.next();
        return P1.getTerm(1).equals(P2.getTerm(0)) && P1.getTerm(0).equals(P2.getTerm(1));
    }

    public static InMemoryAtomSet criticalInstance(Iterable<Rule> rules) {
        DefaultInMemoryGraphStore A = new DefaultInMemoryGraphStore();
        Rules.criticalInstance(rules, A);
        return A;
    }

    public static void criticalInstance(Iterable<Rule> rules, InMemoryAtomSet A) {
        TreeSet<Term> terms = new TreeSet<Term>();
        terms.add(GraalConstant.freshConstant());
        TreeSet<Predicate> predicates = new TreeSet<Predicate>();
        for (Rule r : rules) {
            for (Atom b : r.getBody()) {
                predicates.add(b.getPredicate());
                for (Term t : b.getTerms()) {
                    if (!t.isConstant()) continue;
                    terms.add(t);
                }
            }
        }
        for (Predicate p : predicates) {
            Rules.generateCriticalInstance(A, terms, p, 0, new DefaultAtom(p));
        }
    }

    private static void generateCriticalInstance(InMemoryAtomSet A, Set<Term> terms, Predicate p, int position, DefaultAtom a) {
        if (position >= p.getArity()) {
            A.add(a);
            return;
        }
        for (Term t : terms) {
            DefaultAtom a2 = new DefaultAtom(a);
            a2.setTerm(position, t);
            Rules.generateCriticalInstance(A, terms, p, position + 1, a2);
        }
    }

    private static class SinglePieceRulesIterator
    implements Iterator<Rule> {
        Iterator<Rule> it;
        Queue<Rule> currentMonoPiece = new LinkedList<Rule>();
        Rule currentRule;

        SinglePieceRulesIterator(Iterator<Rule> iterator) {
            this.it = iterator;
        }

        @Override
        public boolean hasNext() {
            return !this.currentMonoPiece.isEmpty() || this.it.hasNext();
        }

        @Override
        public Rule next() {
            if (this.currentMonoPiece.isEmpty()) {
                this.currentRule = this.it.next();
                this.currentMonoPiece.addAll(Rules.computeSinglePiece(this.currentRule));
            }
            return this.currentMonoPiece.poll();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class AtomicHeadIterator
    implements Iterator<Rule> {
        Iterator<Rule> it;
        Queue<Rule> currentAtomicHead = new LinkedList<Rule>();
        Rule currentRule;

        AtomicHeadIterator(Iterator<Rule> iterator) {
            this.it = iterator;
        }

        @Override
        public boolean hasNext() {
            return !this.currentAtomicHead.isEmpty() || this.it.hasNext();
        }

        @Override
        public Rule next() {
            if (this.currentAtomicHead.isEmpty()) {
                this.currentRule = this.it.next();
                this.currentAtomicHead.addAll(Rules.computeAtomicHead(this.currentRule));
            }
            return this.currentAtomicHead.poll();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

