/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.atomset;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.Constant;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Literal;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.core.atomset.AbstractAtomSet;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAccumulator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import fr.lirmm.graphik.util.stream.CloseableIteratorWithoutException;
import fr.lirmm.graphik.util.stream.CounterIterator;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.Set;

public abstract class AbstractInMemoryAtomSet
extends AbstractAtomSet
implements InMemoryAtomSet {
    @Override
    public boolean contains(Atom atom) {
        try {
            return super.contains(atom);
        }
        catch (AtomSetException e) {
            throw new Error("It should never happen.");
        }
    }

    @Override
    public boolean addAll(CloseableIteratorWithoutException<? extends Atom> atoms) {
        try {
            return super.addAll(atoms);
        }
        catch (AtomSetException e) {
            throw new Error("It should never happen.");
        }
    }

    @Override
    public boolean addAll(InMemoryAtomSet atoms) {
        try {
            return super.addAll(atoms);
        }
        catch (AtomSetException e) {
            throw new Error("It should never happen.");
        }
    }

    @Override
    public boolean remove(Atom atom) {
        if (!this.contains(atom)) {
            return false;
        }
        this.removeWithoutCheck(atom);
        return true;
    }

    @Override
    public boolean removeAll(CloseableIteratorWithoutException<? extends Atom> atoms) {
        try {
            return super.removeAll(atoms);
        }
        catch (AtomSetException e) {
            throw new Error("It should never happen.");
        }
    }

    @Override
    public boolean removeAll(InMemoryAtomSet atoms) {
        try {
            return super.removeAll(atoms);
        }
        catch (AtomSetException e) {
            throw new Error("It should never happen.");
        }
    }

    @Override
    public CloseableIterator<Atom> match(Atom atom) throws AtomSetException {
        try {
            return super.match(atom);
        }
        catch (AtomSetException e) {
            throw new Error("It should never happen.");
        }
    }

    @Override
    public Set<Term> getTerms() {
        try {
            return super.getTerms();
        }
        catch (AtomSetException e) {
            throw new Error("It should never happen.");
        }
    }

    @Override
    public Set<Variable> getVariables() {
        try {
            return super.getVariables();
        }
        catch (AtomSetException e) {
            throw new Error("It should never happen.");
        }
    }

    @Override
    public Set<Constant> getConstants() {
        try {
            return super.getConstants();
        }
        catch (AtomSetException e) {
            throw new Error("It should never happen.");
        }
    }

    @Override
    public Set<Literal> getLiterals() {
        try {
            return super.getLiterals();
        }
        catch (AtomSetException e) {
            throw new Error("It should never happen.");
        }
    }

    @Override
    @Deprecated
    public Set<Term> getTerms(Term.Type type) {
        try {
            return super.getTerms(type);
        }
        catch (AtomSetException e) {
            throw new Error("It should never happen.");
        }
    }

    @Override
    public CloseableIteratorWithoutException<Variable> variablesIterator() {
        return new CloseableIteratorAdapter<Variable>(this.getVariables().iterator());
    }

    @Override
    public CloseableIteratorWithoutException<Constant> constantsIterator() {
        return new CloseableIteratorAdapter<Constant>(this.getConstants().iterator());
    }

    @Override
    public CloseableIteratorWithoutException<Literal> literalsIterator() {
        return new CloseableIteratorAdapter<Literal>(this.getLiterals().iterator());
    }

    @Override
    public Set<Predicate> getPredicates() {
        try {
            return super.getPredicates();
        }
        catch (AtomSetException e) {
            throw new Error("It should never happen.");
        }
    }

    @Override
    @Deprecated
    public boolean isSubSetOf(AtomSet atomset) {
        try {
            return super.isSubSetOf(atomset);
        }
        catch (AtomSetException e) {
            throw new Error("It should never happen.");
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            return super.isEmpty();
        }
        catch (AtomSetException e) {
            throw new Error("It should never happen.");
        }
    }

    @Override
    public Atom[] toArray() {
        Atom[] ret;
        CloseableIteratorAccumulator accu;
        try {
            accu = new CloseableIteratorAccumulator(this.iterator());
        }
        catch (IteratorException e1) {
            throw new Error("It should never happen.");
        }
        try {
            ret = (Atom[])accu.consumeAll().toArray();
        }
        catch (IteratorException e) {
            throw new Error("It should never happen.");
        }
        finally {
            accu.close();
        }
        return ret;
    }

    @Override
    public int size() {
        CounterIterator it = new CounterIterator(this.iterator());
        int ret = it.getCptValue();
        it.close();
        return ret;
    }
}

