/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.atomset;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.core.DefaultAtom;
import fr.lirmm.graphik.integraal.core.factory.DefaultAtomSetFactory;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.LinkedList;

public final class AtomSetUtils {
    private AtomSetUtils() {
    }

    public static boolean isSingleton(AtomSet a) throws IteratorException {
        CloseableIterator<Atom> i = a.iterator();
        if (!i.hasNext()) {
            return false;
        }
        i.next();
        return !i.hasNext();
    }

    public static boolean isSingleton(InMemoryAtomSet a) {
        try {
            return AtomSetUtils.isSingleton((AtomSet)a);
        }
        catch (IteratorException e) {
            throw new Error("Should never happen");
        }
    }

    public static boolean hasSize2(AtomSet a) throws IteratorException {
        CloseableIterator<Atom> i = a.iterator();
        if (!i.hasNext()) {
            return false;
        }
        i.next();
        if (!i.hasNext()) {
            return false;
        }
        i.next();
        return !i.hasNext();
    }

    public static boolean hasSize2(InMemoryAtomSet a) {
        try {
            return AtomSetUtils.hasSize2((AtomSet)a);
        }
        catch (IteratorException e) {
            throw new Error("Should never happen");
        }
    }

    public static boolean contains(InMemoryAtomSet a1, InMemoryAtomSet a2) {
        for (Atom a : a2) {
            if (a1.contains(a)) continue;
            return false;
        }
        return true;
    }

    public static InMemoryAtomSet minus(InMemoryAtomSet a1, InMemoryAtomSet a2) {
        InMemoryAtomSet atomset = DefaultAtomSetFactory.instance().create();
        for (Atom a : a1) {
            if (a2.contains(a)) continue;
            atomset.add(a);
        }
        return atomset;
    }

    public static LinkedList<Term> sep(InMemoryAtomSet a1, InMemoryAtomSet a2) {
        InMemoryAtomSet pBar = AtomSetUtils.minus(a2, a1);
        LinkedList<Term> sep = new LinkedList<Term>();
        for (Term t : pBar.getTerms()) {
            for (Term x : a2.getTerms()) {
                if (!x.equals(t)) continue;
                sep.add(t);
            }
        }
        return sep;
    }

    public static InMemoryAtomSet union(InMemoryAtomSet a1, InMemoryAtomSet a2) {
        InMemoryAtomSet atomset = DefaultAtomSetFactory.instance().create();
        for (Atom a : a1) {
            atomset.add(new DefaultAtom(a));
        }
        for (Atom a : a2) {
            if (atomset.contains(a)) continue;
            atomset.add(new DefaultAtom(a));
        }
        return atomset;
    }
}

