/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.atomset.gaifman_graph;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.core.atomset.gaifman_graph.Edge;
import fr.lirmm.graphik.integraal.core.atomset.gaifman_graph.GaifmanGraph;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VariablesGaifmanGraph
implements GaifmanGraph {
    private AtomSet atomset;
    private Set<Edge> edges;
    private Set<Variable> vertices;

    public VariablesGaifmanGraph(AtomSet as) throws IteratorException, AtomSetException {
        this.atomset = as;
        this.vertices = as.getVariables();
        this.buildEdges();
    }

    public VariablesGaifmanGraph(AtomSet as, Set<Variable> existentialVariables) throws IteratorException {
        this.atomset = as;
        this.vertices = existentialVariables;
        this.buildEdges();
    }

    public Set<Variable> getVertices() {
        return this.vertices;
    }

    @Override
    public Set<Edge> getEdges() {
        return this.edges;
    }

    public Collection<Set<Variable>> getConnectedComponents() throws AtomSetException {
        HashMap<Variable, Set> components = new HashMap<Variable, Set>();
        for (Variable v : this.getVertices()) {
            components.put(v, new HashSet());
            ((Set)components.get(v)).add(v);
        }
        for (Edge edge : this.edges) {
            Set y;
            Set x = (Set)components.get(edge.getTerms().getLeft());
            if (x == (y = (Set)components.get(edge.getTerms().getRight()))) continue;
            if (x.size() > y.size()) {
                for (Variable v : y) {
                    components.put(v, x);
                }
                x.addAll(y);
                continue;
            }
            for (Variable v : x) {
                components.put(v, y);
            }
            y.addAll(x);
        }
        ArrayList<Set<Variable>> result = new ArrayList<Set<Variable>>();
        HashSet alreadyAdded = new HashSet();
        for (Map.Entry e : components.entrySet()) {
            if (alreadyAdded.contains(e.getKey())) continue;
            alreadyAdded.addAll((Collection)e.getValue());
            result.add((Set)e.getValue());
        }
        return result;
    }

    private void buildEdges() throws IteratorException {
        this.edges = new HashSet<Edge>();
        CloseableIterator<Atom> it = this.atomset.iterator();
        while (it.hasNext()) {
            Atom a = it.next();
            for (Variable v1 : a.getVariables()) {
                for (Variable v2 : a.getVariables()) {
                    if (!this.vertices.contains(v1) || !this.vertices.contains(v2) || v1.equals(v2)) continue;
                    this.edges.add(new Edge(v1, v2));
                }
            }
        }
    }
}

