/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.atomset.graph;

import fr.lirmm.graphik.integraal.api.core.AbstractAtom;
import fr.lirmm.graphik.integraal.api.core.Constant;
import fr.lirmm.graphik.integraal.api.core.Literal;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.core.atomset.graph.Edge;
import fr.lirmm.graphik.integraal.core.atomset.graph.PredicateVertex;
import fr.lirmm.graphik.integraal.core.atomset.graph.TermVertex;
import fr.lirmm.graphik.integraal.core.atomset.graph.TermVertexFactory;
import fr.lirmm.graphik.integraal.core.atomset.graph.Vertex;
import fr.lirmm.graphik.util.ArrayIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

class AtomEdge
extends AbstractAtom
implements Edge {
    private PredicateVertex predicate;
    private TermVertex[] terms;

    public AtomEdge(PredicateVertex predicate) {
        this.predicate = predicate;
        int n = predicate.getArity();
        this.terms = new TermVertex[n];
    }

    public AtomEdge(PredicateVertex predicate, List<TermVertex> terms) {
        this.predicate = predicate;
        int n = predicate.getArity();
        this.terms = new TermVertex[n];
        int i = 0;
        for (TermVertex t : terms) {
            this.terms[i++] = t;
            if (i != n) continue;
            break;
        }
    }

    @Override
    public void setPredicate(Predicate predicate) {
        this.predicate = new PredicateVertex(predicate);
    }

    @Override
    public Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public void setTerm(int index, Term term) {
        this.terms[index] = TermVertexFactory.instance().createTerm(term);
    }

    @Override
    public TermVertex getTerm(int index) {
        return this.terms[index];
    }

    @Override
    public int indexOf(Term t) {
        return ArrayUtils.indexOf((Object[])this.terms, (Object)t);
    }

    @Override
    public int[] indexesOf(Term term) {
        int[] result = null;
        int resultCounter = 0;
        int termsSize = this.terms.length;
        for (int i = 0; i < termsSize; ++i) {
            if (!this.terms[i].equals(term)) continue;
            ++resultCounter;
        }
        result = new int[resultCounter];
        if (resultCounter != 0) {
            int pos = 0;
            for (int i = 0; i < termsSize; ++i) {
                if (!this.terms[i].equals(term)) continue;
                result[pos] = i;
                ++pos;
            }
        }
        return result;
    }

    @Override
    public boolean contains(Term t) {
        return ArrayUtils.contains((Object[])this.terms, (Object)t);
    }

    @Override
    public List<Term> getTerms() {
        LinkedList<Term> list = new LinkedList<Term>();
        for (TermVertex t : this.terms) {
            list.add(t);
        }
        return list;
    }

    @Override
    @Deprecated
    public Collection<Term> getTerms(Term.Type type) {
        LinkedList<Term> typedTerms = new LinkedList<Term>();
        for (TermVertex term : this.terms) {
            if (!type.equals((Object)term.getType())) continue;
            typedTerms.add(term);
        }
        return typedTerms;
    }

    @Override
    public Set<Constant> getConstants() {
        HashSet<Constant> typedTerms = new HashSet<Constant>();
        for (TermVertex term : this.terms) {
            if (!term.isConstant()) continue;
            typedTerms.add((Constant)((Object)term));
        }
        return typedTerms;
    }

    @Override
    public Set<Variable> getVariables() {
        HashSet<Variable> typedTerms = new HashSet<Variable>();
        for (TermVertex term : this.terms) {
            if (!term.isVariable()) continue;
            typedTerms.add((Variable)((Object)term));
        }
        return typedTerms;
    }

    @Override
    public Set<Literal> getLiterals() {
        HashSet<Literal> typedTerms = new HashSet<Literal>();
        for (TermVertex term : this.terms) {
            if (!term.isLiteral()) continue;
            typedTerms.add((Literal)((Object)term));
        }
        return typedTerms;
    }

    @Override
    public Iterator<Term> iterator() {
        return new ArrayIterator<Term>(this.terms);
    }

    @Override
    public Set<Vertex> getVertices() {
        HashSet<Vertex> set = new HashSet<Vertex>();
        for (TermVertex t : this.terms) {
            set.add(t);
        }
        set.add(this.predicate);
        return set;
    }
}

