/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.atomset.graph;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.TermGenerator;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.api.store.BatchProcessor;
import fr.lirmm.graphik.integraal.api.store.Store;
import fr.lirmm.graphik.integraal.core.AtomType;
import fr.lirmm.graphik.integraal.core.DefaultVariableGenerator;
import fr.lirmm.graphik.integraal.core.TypeFilter;
import fr.lirmm.graphik.integraal.core.atomset.AbstractInMemoryAtomSet;
import fr.lirmm.graphik.integraal.core.atomset.graph.AtomEdge;
import fr.lirmm.graphik.integraal.core.atomset.graph.CurrentIndexFactory;
import fr.lirmm.graphik.integraal.core.atomset.graph.Edge;
import fr.lirmm.graphik.integraal.core.atomset.graph.PredicateVertex;
import fr.lirmm.graphik.integraal.core.atomset.graph.TermVertex;
import fr.lirmm.graphik.integraal.core.atomset.graph.TermVertexFactory;
import fr.lirmm.graphik.integraal.core.store.DefaultBatchProcessor;
import fr.lirmm.graphik.util.stream.CloseableIterableAdapter;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import fr.lirmm.graphik.util.stream.CloseableIteratorWithoutException;
import fr.lirmm.graphik.util.stream.Iterators;
import fr.lirmm.graphik.util.stream.filter.Filter;
import fr.lirmm.graphik.util.stream.filter.FilterIteratorWithoutException;
import fr.lirmm.graphik.util.stream.filter.UniqFilter;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultInMemoryGraphStore
extends AbstractInMemoryAtomSet
implements Store {
    private int size = 0;
    private Map<Term, TermVertex> terms;
    private Map<Predicate, PredicateVertex> predicates;
    private Map<Predicate, Set<Term>[]> termsByPredicatePosition;
    private TermGenerator freshSymbolGenerator = new DefaultVariableGenerator("EE", this);

    public DefaultInMemoryGraphStore() {
        this.terms = CurrentIndexFactory.instance().createMap();
        this.predicates = CurrentIndexFactory.instance().createMap();
        this.termsByPredicatePosition = CurrentIndexFactory.instance().createMap();
    }

    @Override
    public Set<Predicate> getPredicates() {
        return Collections.unmodifiableSet(this.predicates.keySet());
    }

    @Override
    public CloseableIteratorWithoutException<Predicate> predicatesIterator() {
        return new CloseableIteratorAdapter<Predicate>(this.getPredicates().iterator());
    }

    @Override
    public CloseableIteratorWithoutException<Atom> iterator() {
        return new CloseableIteratorAdapter<Atom>(this.predicates.keySet().stream().flatMap(p -> this.predicates.get(p).getNeighbors().stream()).map(e -> (Atom)((Object)e)).iterator());
    }

    public CloseableIteratorWithoutException<Atom> atomsByTerm(Term term) {
        if (this.getTermVertex(term) == null) {
            return Iterators.emptyIterator();
        }
        return new CloseableIterableAdapter<Atom>(this.getTermVertex(term).getNeighbors()).iterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeWithoutCheck(Atom atom) {
        if (!this.contains(atom)) {
            return;
        }
        LinkedList<TermVertex> atomTerms = new LinkedList<TermVertex>();
        for (Term term : atom.getTerms()) {
            TermVertex tv = this.terms.get(term);
            atomTerms.add(tv);
        }
        PredicateVertex atomPredicate = this.predicates.get(atom.getPredicate());
        AtomEdge atomEdge = new AtomEdge(atomPredicate, atomTerms);
        atomPredicate.removeNeighbor(atomEdge);
        for (TermVertex t : atomTerms) {
            t.removeNeighbor(atomEdge);
        }
        boolean bl = false;
        for (TermVertex tv : atomTerms) {
            void var5_7;
            if (!tv.getNeighbors(atomPredicate, (int)var5_7).hasNext()) {
                this.termsByPredicatePosition.get(atom.getPredicate())[var5_7].remove(tv);
            }
            ++var5_7;
        }
        if (atomPredicate.isEmptyNeighbor()) {
            this.predicates.remove(atomPredicate);
            this.termsByPredicatePosition.remove(atomPredicate);
        }
        for (TermVertex t : atomTerms) {
            if (!t.isEmptyNeighbor()) continue;
            this.terms.remove(t);
        }
        --this.size;
    }

    @Override
    public boolean contains(Atom atom) {
        PredicateVertex predicateVertex = this.predicates.get(atom.getPredicate());
        if (predicateVertex == null) {
            return false;
        }
        return predicateVertex.getNeighbors().contains(atom);
    }

    @Override
    public CloseableIteratorWithoutException<Atom> match(Atom atom, Substitution s) {
        CloseableIteratorWithoutException<Object> it = null;
        AtomType atomType = new AtomType(atom, s);
        if (atomType.isThereConstant()) {
            int i = -1;
            int size = Integer.MAX_VALUE;
            for (Term t : atom.getTerms()) {
                ++i;
                if (!t.isConstant() && !s.getTerms().contains(t)) continue;
                TermVertex tv = this.getTermVertex(s.createImageOf(t));
                if (tv != null) {
                    int tmpSize = tv.neighborhoodSize(atom.getPredicate(), i);
                    if (tmpSize >= size) continue;
                    size = tmpSize;
                    it = tv.getNeighbors(atom.getPredicate(), i);
                    continue;
                }
                size = 0;
                it = Iterators.emptyIterator();
            }
        } else {
            it = this.atomsByPredicate(atom.getPredicate());
        }
        if (atomType.isThereConstraint()) {
            return new FilterIteratorWithoutException((CloseableIteratorWithoutException<Atom>)it, (Filter<Atom>)new TypeFilter(atomType, s.createImageOf(atom)));
        }
        return it;
    }

    @Override
    public CloseableIteratorWithoutException<Atom> atomsByPredicate(Predicate p) {
        PredicateVertex pv = this.getPredicateVertex(p);
        if (pv == null) {
            return Iterators.emptyIterator();
        }
        return new FilterIteratorWithoutException((CloseableIteratorWithoutException<Edge>)new CloseableIteratorAdapter<Edge>(pv.getNeighbors().iterator()), new Filter<Edge>(){

            @Override
            public boolean filter(Edge e) {
                return true;
            }
        });
    }

    @Override
    public int size(Predicate p) {
        PredicateVertex pred = this.getPredicateVertex(p);
        return pred == null ? 0 : pred.getNeighbors().size();
    }

    @Override
    public int getDomainSize() {
        return this.terms.size();
    }

    @Override
    public CloseableIteratorWithoutException<Term> termsByPredicatePosition(Predicate p, int position) {
        Set<Term>[] sets = this.termsByPredicatePosition.get(p);
        if (sets == null) {
            return new CloseableIteratorAdapter<Term>(Collections.emptyList().iterator());
        }
        return new CloseableIteratorAdapter<Term>(sets[position].iterator());
    }

    @Override
    public Set<Term> getTerms() {
        return Collections.unmodifiableSet(this.terms.keySet());
    }

    @Override
    public CloseableIteratorWithoutException<Term> termsIterator() {
        return new CloseableIteratorAdapter<Term>(this.getTerms().iterator());
    }

    @Override
    @Deprecated
    public Set<Term> getTerms(Term.Type type) {
        HashSet<Term> set = new HashSet<Term>();
        for (Term t : this.terms.keySet()) {
            if (!type.equals((Object)t.getType())) continue;
            set.add(t);
        }
        return set;
    }

    @Override
    @Deprecated
    public CloseableIteratorWithoutException<Term> termsIterator(Term.Type type) {
        return new CloseableIteratorAdapter<Term>(this.getTerms(type).iterator());
    }

    @Override
    public boolean add(Atom atom) {
        LinkedList<TermVertex> atomTerms = new LinkedList<TermVertex>();
        for (Term t : atom.getTerms()) {
            atomTerms.add(this.addTermVertex(TermVertexFactory.instance().createTerm(t)));
        }
        PredicateVertex atomPredicate = this.addPredicateVertex(new PredicateVertex(atom.getPredicate()));
        AtomEdge atomEdge = new AtomEdge(atomPredicate, atomTerms);
        return this.addAtomEdge(atomEdge);
    }

    @Override
    public void clear() {
        this.terms.clear();
        this.predicates.clear();
        this.termsByPredicatePosition.clear();
        this.size = 0;
    }

    @Override
    public TermGenerator getFreshSymbolGenerator() {
        return this.freshSymbolGenerator;
    }

    @Override
    public int size() {
        return this.size;
    }

    private TermVertex getTermVertex(Term term) {
        return this.terms.get(term);
    }

    private PredicateVertex getPredicateVertex(Predicate predicate) {
        return this.predicates.get(predicate);
    }

    private TermVertex addTermVertex(TermVertex term) {
        TermVertex t = this.terms.get(term);
        if (t == null) {
            t = term;
            this.terms.put(t, t);
        }
        return t;
    }

    private PredicateVertex addPredicateVertex(PredicateVertex predicate) {
        PredicateVertex p = this.predicates.get(predicate);
        if (p == null) {
            p = predicate;
            this.predicates.put(p, p);
            Set[] array = new Set[predicate.getArity()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = CurrentIndexFactory.instance().createSet();
            }
            this.termsByPredicatePosition.put(p, array);
        }
        return p;
    }

    private boolean addAtomEdge(AtomEdge atom) {
        PredicateVertex predicateVertex = this.predicates.get(atom.getPredicate());
        boolean val = predicateVertex.addNeighbor(atom);
        if (val) {
            ++this.size;
            FilterIteratorWithoutException it = new FilterIteratorWithoutException(atom.getTerms().iterator(), new UniqFilter());
            while (it.hasNext()) {
                TermVertex term = (TermVertex)it.next();
                term.addNeighbor(atom);
            }
            it.close();
            Set<Term>[] sets = this.termsByPredicatePosition.get(atom.getPredicate());
            int i = -1;
            for (Term t : atom) {
                sets[++i].add(t);
            }
        }
        return val;
    }

    @Override
    public BatchProcessor createBatchProcessor() throws AtomSetException {
        return new DefaultBatchProcessor(this);
    }

    @Override
    public boolean isWriteable() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean containsTerm(Term t) throws AtomSetException {
        return this.terms.containsKey(t);
    }

    @Override
    public Set<Variable> getVariables() {
        return this.terms.keySet().parallelStream().filter(t -> t.isVariable()).map(v -> (Variable)v).collect(Collectors.toSet());
    }
}

