/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.compilation;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.core.Substitutions;
import fr.lirmm.graphik.integraal.core.atomset.DefaultInMemoryAtomSet;
import fr.lirmm.graphik.util.profiler.Profiler;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class AbstractRulesCompilation
implements RulesCompilation {
    private Profiler profiler;

    @Override
    public void setProfiler(Profiler profiler) {
        this.profiler = profiler;
    }

    @Override
    public Profiler getProfiler() {
        return this.profiler;
    }

    @Override
    public InMemoryAtomSet getIrredondant(InMemoryAtomSet atomSet) {
        DefaultInMemoryAtomSet irr = new DefaultInMemoryAtomSet(atomSet);
        CloseableIterator i = irr.iterator();
        DefaultInMemoryAtomSet toRemove = new DefaultInMemoryAtomSet();
        while (i.hasNext()) {
            Atom target = (Atom)i.next();
            CloseableIterator j = irr.iterator();
            boolean isSubsumed = false;
            while (j.hasNext() && !isSubsumed) {
                Atom origin = (Atom)j.next();
                if (target == origin || toRemove.contains(origin) || !this.isImplied(target, origin)) continue;
                isSubsumed = true;
                toRemove.add(target);
            }
        }
        irr.removeAll(toRemove);
        return irr;
    }

    protected final LinkedList<Rule> extractCompilable(Iterator<Rule> ruleSet) {
        LinkedList<Rule> compilable = new LinkedList<Rule>();
        while (ruleSet.hasNext()) {
            Rule r = ruleSet.next();
            if (!this.isCompilable(r)) continue;
            compilable.add(r);
            ruleSet.remove();
        }
        if (this.getProfiler() != null) {
            this.getProfiler().put("Compiled rules", compilable.size());
        }
        return compilable;
    }

    @Override
    public Collection<Substitution> homomorphism(Atom father, Atom son) {
        return this.homomorphism(father, son, Substitutions.emptySubstitution());
    }
}

