/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.compilation;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.core.DefaultAtom;
import fr.lirmm.graphik.integraal.core.Substitutions;
import fr.lirmm.graphik.integraal.core.compilation.AbstractRulesCompilation;
import fr.lirmm.graphik.integraal.core.factory.DefaultSubstitutionFactory;
import fr.lirmm.graphik.util.Partition;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class HierarchicalCompilation
extends AbstractRulesCompilation {
    private TreeMap<Predicate, Integer> predicateIndex;
    private ArrayList<Predicate> indexPredicate;
    private byte[][] order;
    int sizeOrder = 0;
    private LinkedList<Rule> rules = new LinkedList();

    public HierarchicalCompilation() {
        this.predicateIndex = new TreeMap();
        this.indexPredicate = new ArrayList();
    }

    @Override
    public Iterable<Rule> getSaturation() {
        return this.rules;
    }

    @Override
    public void compile(Iterator<Rule> ruleset) {
        this.rules = this.extractCompilable(ruleset);
        this.computeIndex(this.rules);
    }

    @Override
    public void load(Iterator<Rule> ruleset, Iterator<Rule> compilation) {
        this.extractCompilable(ruleset);
        while (compilation.hasNext()) {
            this.rules.add(compilation.next());
        }
        this.computeIndex(this.rules);
    }

    @Override
    public boolean isCompilable(Rule rule) {
        CloseableIterator headIt = rule.getHead().iterator();
        CloseableIterator bodyIt = rule.getBody().iterator();
        if (headIt.hasNext() && bodyIt.hasNext()) {
            Atom father = (Atom)headIt.next();
            Atom son = (Atom)bodyIt.next();
            if (!headIt.hasNext() && !bodyIt.hasNext() && father.getPredicate().getArity() == son.getPredicate().getArity()) {
                for (int j = 0; j < father.getPredicate().getArity(); ++j) {
                    if (!father.getTerm(j).isConstant() && father.getTerm(j).equals(son.getTerm(j))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isMappable(Predicate father, Predicate son) {
        Integer f = this.predicateIndex.get(father);
        Integer s = this.predicateIndex.get(son);
        if (f != null && s != null) {
            return this.order[f][s] == 1;
        }
        return son.equals(father);
    }

    @Override
    public Collection<Substitution> homomorphism(Atom father, Atom son, Substitution s) {
        Set<Variable> fixedTerms = s.getTerms();
        LinkedList<Substitution> res = new LinkedList<Substitution>();
        if (this.isMappable(father.getPredicate(), son.getPredicate())) {
            Substitution sub = DefaultSubstitutionFactory.instance().createSubstitution();
            Iterator<Term> fatherTermsIt = father.getTerms().iterator();
            Iterator<Term> sonTermsIt = son.getTerms().iterator();
            while (fatherTermsIt.hasNext() && sonTermsIt.hasNext()) {
                Term fatherTerm = fatherTermsIt.next();
                Term sonTerm = sonTermsIt.next();
                if (fatherTerm.isConstant() || fixedTerms.contains(fatherTerm)) {
                    if (s.createImageOf(fatherTerm).equals(sonTerm)) continue;
                    return res;
                }
                if (!sub.getTerms().contains(fatherTerm)) {
                    sub.put((Variable)fatherTerm, sonTerm);
                    continue;
                }
                if (sub.createImageOf(fatherTerm).equals(sonTerm)) continue;
                return res;
            }
            res.add(sub);
        }
        return res;
    }

    @Override
    public Collection<Partition<Term>> getUnification(Atom father, Atom son) {
        LinkedList<Partition<Term>> res = new LinkedList<Partition<Term>>();
        if (this.isMappable(father.getPredicate(), son.getPredicate())) {
            res.add(new Partition<Term>(father.getTerms(), son.getTerms()));
        }
        return res;
    }

    @Override
    public boolean isImplied(Atom father, Atom son) {
        Predicate predFather = father.getPredicate();
        Predicate predSon = son.getPredicate();
        Integer f = this.predicateIndex.get(predFather);
        Integer s = this.predicateIndex.get(predSon);
        if (f != null && s != null && Objects.equals(father.getTerms(), son.getTerms())) {
            return this.order[f][s] == 1;
        }
        return false;
    }

    @Override
    public Collection<Predicate> getUnifiablePredicate(Predicate p) {
        LinkedList<Predicate> res = new LinkedList<Predicate>();
        res.add(p);
        Integer index = this.predicateIndex.get(p);
        if (index != null) {
            for (int i = 0; i < this.sizeOrder; ++i) {
                if (this.order[index][i] != 1) continue;
                res.add(this.indexPredicate.get(i));
            }
        }
        return res;
    }

    @Override
    public Collection<Pair<Atom, Substitution>> getRewritingOf(Atom father) {
        LinkedList<Pair<Atom, Substitution>> res = new LinkedList<Pair<Atom, Substitution>>();
        res.add((Pair<Atom, Substitution>)new ImmutablePair((Object)father, (Object)Substitutions.emptySubstitution()));
        Integer index = this.predicateIndex.get(father.getPredicate());
        if (index != null) {
            for (int i = 0; i < this.sizeOrder; ++i) {
                if (this.order[index][i] != 1) continue;
                DefaultAtom a = new DefaultAtom(father);
                a.setPredicate(this.indexPredicate.get(i));
                res.add((Pair<Atom, Substitution>)new ImmutablePair((Object)a, (Object)Substitutions.emptySubstitution()));
            }
        }
        return res;
    }

    private void computeTransitiveClosure(int father, int son) {
        for (int i = 0; i < this.sizeOrder; ++i) {
            if (this.order[son][i] != 1) continue;
            this.order[father][i] = 1;
        }
        for (int j = 0; j < this.sizeOrder; ++j) {
            if (this.order[j][father] != 1) continue;
            for (int i = 0; i < this.sizeOrder; ++i) {
                if (this.order[father][i] != 1) continue;
                this.order[j][i] = 1;
            }
        }
    }

    private boolean addPredicate(Predicate p) {
        if (this.predicateIndex.get(p) == null) {
            this.predicateIndex.put(p, this.sizeOrder++);
            this.indexPredicate.add(p);
            return true;
        }
        return false;
    }

    private void addRule(Atom father, Atom son) {
        Predicate predFather = father.getPredicate();
        Predicate predSon = son.getPredicate();
        Integer f = this.predicateIndex.get(predFather);
        Integer s = this.predicateIndex.get(predSon);
        this.order[f.intValue()][s.intValue()] = 1;
        this.computeTransitiveClosure(f, s);
    }

    private void computeIndex(Iterable<Rule> ruleset) {
        for (Rule rule : ruleset) {
            CloseableIterator it = rule.getBody().predicatesIterator();
            while (it.hasNext()) {
                this.addPredicate((Predicate)it.next());
            }
            it = rule.getHead().predicatesIterator();
            while (it.hasNext()) {
                this.addPredicate((Predicate)it.next());
            }
        }
        int nbPred = this.indexPredicate.size();
        this.order = new byte[nbPred][nbPred];
        for (Rule ru : ruleset) {
            Atom father = (Atom)ru.getHead().iterator().next();
            Atom son = (Atom)ru.getBody().iterator().next();
            this.addRule(father, son);
        }
        for (int i = 0; i < this.order.length; ++i) {
            this.order[i][i] = 1;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    public String toString() {
        Object s = "";
        for (int i = 0; i < this.sizeOrder; ++i) {
            s = (String)s + this.indexPredicate.get(i) + " | ";
            for (int j = 0; j < this.sizeOrder; ++j) {
                if (this.order[i][j] != 1) continue;
                s = (String)s + this.indexPredicate.get(j) + " ";
            }
            s = (String)s + "\n";
        }
        return s;
    }
}

