/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.compilation;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.core.Substitutions;
import fr.lirmm.graphik.integraal.core.compilation.AbstractRulesCompilation;
import fr.lirmm.graphik.integraal.core.factory.DefaultSubstitutionFactory;
import fr.lirmm.graphik.util.Partition;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class NoCompilation
extends AbstractRulesCompilation {
    private static NoCompilation instance;

    protected NoCompilation() {
    }

    public static synchronized NoCompilation instance() {
        if (instance == null) {
            instance = new NoCompilation();
        }
        return instance;
    }

    @Override
    public void compile(Iterator<Rule> ruleset) {
    }

    @Override
    public void load(Iterator<Rule> ruleset, Iterator<Rule> compilation) {
    }

    @Override
    public Iterable<Rule> getSaturation() {
        return Collections.emptyList();
    }

    @Override
    public boolean isCompilable(Rule r) {
        return false;
    }

    @Override
    public boolean isMappable(Predicate father, Predicate son) {
        return son.equals(father);
    }

    @Override
    public Collection<Substitution> homomorphism(Atom father, Atom son, Substitution s) {
        Set<Variable> fixedTerms = s.getTerms();
        LinkedList<Substitution> res = new LinkedList<Substitution>();
        if (father.getPredicate().equals(son.getPredicate())) {
            Substitution sub = DefaultSubstitutionFactory.instance().createSubstitution();
            Iterator<Term> fatherTermsIt = father.getTerms().iterator();
            Iterator<Term> sonTermsIt = son.getTerms().iterator();
            while (fatherTermsIt.hasNext() && sonTermsIt.hasNext()) {
                Term fatherTerm = fatherTermsIt.next();
                Term sonTerm = sonTermsIt.next();
                if (fatherTerm.isConstant() || fixedTerms.contains(fatherTerm)) {
                    if (s.createImageOf(fatherTerm).equals(sonTerm)) continue;
                    return res;
                }
                if (!sub.getTerms().contains(fatherTerm)) {
                    sub.put((Variable)fatherTerm, sonTerm);
                    continue;
                }
                if (sub.createImageOf(fatherTerm).equals(sonTerm)) continue;
                return res;
            }
            res.add(sub);
        }
        return res;
    }

    @Override
    public Collection<Partition<Term>> getUnification(Atom father, Atom son) {
        LinkedList<Partition<Term>> res = new LinkedList<Partition<Term>>();
        if (this.isMappable(father.getPredicate(), son.getPredicate())) {
            res.add(new Partition<Term>(father.getTerms(), son.getTerms()));
        }
        return res;
    }

    @Override
    public boolean isImplied(Atom father, Atom son) {
        return Objects.equals(son, father);
    }

    @Override
    public Collection<Pair<Atom, Substitution>> getRewritingOf(Atom father) {
        return Collections.singleton(new ImmutablePair((Object)father, (Object)Substitutions.emptySubstitution()));
    }

    @Override
    public Collection<Predicate> getUnifiablePredicate(Predicate p) {
        return Collections.singleton(p);
    }

    @Override
    public boolean isEmpty() {
        return true;
    }
}

