/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.factory;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.factory.InMemoryAtomSetFactory;
import fr.lirmm.graphik.integraal.core.atomset.DefaultInMemoryAtomSet;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorWithoutException;
import fr.lirmm.graphik.util.stream.IteratorException;

public final class DefaultAtomSetFactory
implements InMemoryAtomSetFactory {
    private static DefaultAtomSetFactory instance = new DefaultAtomSetFactory();

    private DefaultAtomSetFactory() {
    }

    public static DefaultAtomSetFactory instance() {
        return instance;
    }

    @Override
    public InMemoryAtomSet create() {
        return new DefaultInMemoryAtomSet();
    }

    @Override
    public InMemoryAtomSet create(Atom ... atoms) {
        InMemoryAtomSet atomset = this.create();
        for (Atom a : atoms) {
            atomset.add(a);
        }
        return atomset;
    }

    @Override
    public InMemoryAtomSet create(CloseableIterator<Atom> atoms) throws IteratorException {
        InMemoryAtomSet atomset = this.create();
        while (atoms.hasNext()) {
            atomset.add(atoms.next());
        }
        return atomset;
    }

    @Override
    public InMemoryAtomSet create(CloseableIteratorWithoutException<Atom> atoms) {
        InMemoryAtomSet atomset = this.create();
        while (atoms.hasNext()) {
            atomset.add(atoms.next());
        }
        return atomset;
    }

    @Override
    public InMemoryAtomSet create(AtomSet src) throws IteratorException {
        InMemoryAtomSet atomset = this.create();
        CloseableIterator<Atom> it = src.iterator();
        while (it.hasNext()) {
            Atom a = it.next();
            atomset.add(a);
        }
        return atomset;
    }

    @Override
    public InMemoryAtomSet create(InMemoryAtomSet src) {
        try {
            return this.create((AtomSet)src);
        }
        catch (IteratorException e) {
            throw new Error("Should never happen");
        }
    }

    @Override
    public InMemoryAtomSet create(Atom atom) {
        return new DefaultInMemoryAtomSet(atom);
    }
}

