/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.mapper;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.TermGenerator;
import fr.lirmm.graphik.integraal.api.core.mapper.Mapper;
import fr.lirmm.graphik.integraal.api.store.Store;
import fr.lirmm.graphik.integraal.core.mapper.MapperAtomConverter;
import fr.lirmm.graphik.integraal.core.mapper.MapperPredicateConverter;
import fr.lirmm.graphik.integraal.core.store.AbstractStore;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.converter.ConverterCloseableIterator;
import java.io.Closeable;
import java.io.IOException;

public class MappedStore
extends AbstractStore {
    private Store store;
    private Mapper mapper;
    private MapperAtomConverter converter;
    private MapperAtomConverter unconverter;
    private MapperPredicateConverter predicateUnconverter;

    public MappedStore(Store store, Mapper mapper) {
        this.store = store;
        this.mapper = mapper;
        this.converter = new MapperAtomConverter(this.mapper);
        this.unconverter = new MapperAtomConverter(this.mapper.inverse());
        this.predicateUnconverter = new MapperPredicateConverter(this.mapper.inverse());
    }

    @Override
    public boolean isWriteable() throws AtomSetException {
        return this.store.isWriteable();
    }

    @Override
    public CloseableIterator<Atom> iterator() {
        return new ConverterCloseableIterator<Atom, Atom>(this.store.iterator(), this.unconverter);
    }

    @Override
    public CloseableIterator<Atom> match(Atom atom, Substitution s) throws AtomSetException {
        CloseableIterator<Atom> match = this.store.match(this.mapper.map(atom), s);
        return new ConverterCloseableIterator<Atom, Atom>(match, this.unconverter);
    }

    @Override
    public CloseableIterator<Atom> atomsByPredicate(Predicate p) throws AtomSetException {
        CloseableIterator<Atom> atomsByPredicate = this.store.atomsByPredicate(this.mapper.map(p));
        return new ConverterCloseableIterator<Atom, Atom>(atomsByPredicate, this.unconverter);
    }

    @Override
    public CloseableIterator<Term> termsByPredicatePosition(Predicate p, int position) throws AtomSetException {
        return this.store.termsByPredicatePosition(this.mapper.map(p), position);
    }

    @Override
    public CloseableIterator<Predicate> predicatesIterator() throws AtomSetException {
        return new ConverterCloseableIterator<Predicate, Predicate>(this.store.predicatesIterator(), this.predicateUnconverter);
    }

    @Override
    public CloseableIterator<Term> termsIterator() throws AtomSetException {
        return this.store.termsIterator();
    }

    @Override
    @Deprecated
    public CloseableIterator<Term> termsIterator(Term.Type type) throws AtomSetException {
        return this.store.termsIterator(type);
    }

    @Override
    public void close() {
        if (this.store instanceof Closeable) {
            try {
                ((Closeable)((Object)this.store)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean add(Atom atom) throws AtomSetException {
        return this.store.add(this.mapper.map(atom));
    }

    @Override
    public boolean addAll(CloseableIterator<? extends Atom> it) throws AtomSetException {
        return this.store.addAll(new ConverterCloseableIterator<Atom, Atom>(it, this.converter));
    }

    @Override
    public boolean remove(Atom atom) throws AtomSetException {
        return this.store.remove(this.mapper.map(atom));
    }

    @Override
    public void removeWithoutCheck(Atom atom) throws AtomSetException {
        this.store.removeWithoutCheck(this.mapper.map(atom));
    }

    @Override
    public void clear() throws AtomSetException {
        this.store.clear();
    }

    @Override
    public TermGenerator getFreshSymbolGenerator() {
        return this.store.getFreshSymbolGenerator();
    }
}

