/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.mapper;

import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.core.mapper.AbstractMapper;
import fr.lirmm.graphik.util.URI;

public class PrefixMapper
extends AbstractMapper {
    private String prefix;
    private String format;

    public PrefixMapper(String prefix) {
        this.prefix = prefix;
        this.format = prefix + "%s";
    }

    @Override
    public Predicate map(Predicate predicate) {
        return new Predicate(String.format(this.format, predicate.getIdentifier()), predicate.getArity());
    }

    @Override
    public Predicate unmap(Predicate predicate) {
        Object identifier = predicate.getIdentifier();
        String id = null;
        if (identifier instanceof String) {
            id = (String)identifier;
        } else if (identifier instanceof URI) {
            id = ((URI)identifier).toString();
        } else {
            return predicate;
        }
        if (id.startsWith(this.prefix)) {
            return new Predicate(id.substring(this.prefix.length()), predicate.getArity());
        }
        return predicate;
    }
}

