/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.ruleset;

import fr.lirmm.graphik.integraal.api.core.NegativeConstraint;
import fr.lirmm.graphik.integraal.api.core.Ontology;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.RuleLabeler;
import fr.lirmm.graphik.integraal.api.core.RuleSet;
import fr.lirmm.graphik.integraal.api.core.RuleSetException;
import fr.lirmm.graphik.integraal.core.DefaultRuleLabeler;
import fr.lirmm.graphik.integraal.core.stream.filter.RuleFilterIterator;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DefaultOntology
implements Ontology {
    private Map<String, Rule> map = new HashMap<String, Rule>();
    private Map<String, NegativeConstraint> constraintsMap = new HashMap<String, NegativeConstraint>();
    private Set<Predicate> vocabulary;
    private RuleLabeler labeler = new DefaultRuleLabeler();

    public DefaultOntology() {
        this.vocabulary = new TreeSet<Predicate>();
    }

    public DefaultOntology(RuleSet rules) {
        this();
        this.addAll(rules.iterator());
    }

    public DefaultOntology(CloseableIterator<Object> parser) throws RuleSetException {
        this();
        this.addAll(new RuleFilterIterator(parser));
        parser.close();
    }

    @Override
    public Set<String> getRuleNames() {
        return this.map.keySet();
    }

    @Override
    public Rule getRule(String name) {
        return this.map.get(name);
    }

    @Override
    public Set<String> getNegativeConstraintNames() {
        return this.constraintsMap.keySet();
    }

    @Override
    public NegativeConstraint getNegativeConstraint(String name) {
        return this.constraintsMap.get(name);
    }

    @Override
    public boolean add(Rule rule) {
        if (rule == null) {
            return false;
        }
        if (rule.equals(this.map.get(rule.getLabel()))) {
            return false;
        }
        this.vocabulary.addAll(rule.getBody().getPredicates());
        this.vocabulary.addAll(rule.getHead().getPredicates());
        this.labeler.setLabel(rule);
        if (rule instanceof NegativeConstraint) {
            this.constraintsMap.put(rule.getLabel(), (NegativeConstraint)rule);
        }
        return this.map.put(rule.getLabel(), rule) == null;
    }

    @Override
    public boolean addAll(Iterator<Rule> ruleIterator) {
        boolean b = true;
        while (ruleIterator.hasNext()) {
            b = this.add(ruleIterator.next()) && b;
        }
        return b;
    }

    @Override
    public boolean addAll(CloseableIterator<Rule> ruleIterator) throws RuleSetException {
        boolean b = true;
        try {
            while (ruleIterator.hasNext()) {
                b = this.add(ruleIterator.next()) && b;
            }
        }
        catch (IteratorException e) {
            throw new RuleSetException(e);
        }
        finally {
            ruleIterator.close();
        }
        return b;
    }

    @Override
    public boolean remove(Rule rule) {
        boolean res = this.removeWithoutVocReset(rule);
        if (res) {
            this.resetVocabulary();
        }
        return res;
    }

    @Override
    public boolean removeAll(Iterator<Rule> ruleIterator) {
        boolean b = true;
        while (ruleIterator.hasNext()) {
            b = this.removeWithoutVocReset(ruleIterator.next()) && b;
        }
        if (b) {
            this.resetVocabulary();
        }
        return b;
    }

    @Override
    public boolean removeAll(CloseableIterator<Rule> ruleIterator) throws RuleSetException {
        boolean b = true;
        try {
            while (ruleIterator.hasNext()) {
                b = this.removeWithoutVocReset(ruleIterator.next()) && b;
            }
        }
        catch (IteratorException e) {
            throw new RuleSetException(e);
        }
        finally {
            ruleIterator.close();
        }
        if (b) {
            this.resetVocabulary();
        }
        return b;
    }

    @Override
    public boolean contains(Rule rule) {
        return this.map.containsValue(rule);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Iterator<Rule> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public Set<Predicate> getVocabulary() {
        return Collections.unmodifiableSet(this.vocabulary);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    private void resetVocabulary() {
        this.vocabulary = new TreeSet<Predicate>();
        for (Rule r : this) {
            this.vocabulary.addAll(r.getBody().getPredicates());
            this.vocabulary.addAll(r.getHead().getPredicates());
        }
    }

    private boolean removeWithoutVocReset(Rule rule) {
        if (rule instanceof NegativeConstraint) {
            this.constraintsMap.remove(rule.getLabel());
        }
        return this.map.remove(rule.getLabel()) != null;
    }
}

