/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.term;

import fr.lirmm.graphik.integraal.api.core.Constant;
import fr.lirmm.graphik.integraal.api.core.Literal;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.api.factory.TermFactory;
import fr.lirmm.graphik.integraal.core.term.DefaultConstant;
import fr.lirmm.graphik.integraal.core.term.DefaultLiteral;
import fr.lirmm.graphik.integraal.core.term.DefaultVariable;
import fr.lirmm.graphik.util.URI;

public class DefaultTermFactory
implements TermFactory {
    private static final TermFactory INSTANCE = new DefaultTermFactory();

    public static TermFactory instance() {
        return INSTANCE;
    }

    @Override
    public Term createTerm(Term term) {
        if (term instanceof DefaultVariable) {
            return term;
        }
        if (term instanceof DefaultConstant) {
            return term;
        }
        if (term instanceof DefaultLiteral) {
            return term;
        }
        if (term instanceof Variable) {
            return new DefaultVariable((Variable)term);
        }
        if (term instanceof Constant) {
            return new DefaultConstant((Constant)term);
        }
        if (term instanceof Literal) {
            return new DefaultLiteral((Literal)term);
        }
        return null;
    }

    @Override
    @Deprecated
    public Term createTerm(Object o, Term.Type type) {
        switch (type) {
            case VARIABLE: {
                return this.createVariable(o);
            }
            case CONSTANT: {
                return this.createConstant(o);
            }
            case LITERAL: {
                return this.createLiteral(o);
            }
        }
        return null;
    }

    @Override
    public Variable createVariable(Object identifier) {
        return new DefaultVariable(identifier);
    }

    @Override
    public Literal createLiteral(Object value) {
        return new DefaultLiteral(value);
    }

    @Override
    public Literal createLiteral(URI datatype, Object value) {
        return new DefaultLiteral(datatype, value);
    }

    @Override
    public Constant createConstant(Object identifier) {
        return new DefaultConstant(identifier);
    }
}

