/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.unifier;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.api.core.VariableGenerator;
import fr.lirmm.graphik.integraal.core.DefaultVariableGenerator;
import fr.lirmm.graphik.integraal.core.atomset.DefaultInMemoryAtomSet;
import fr.lirmm.graphik.integraal.core.factory.DefaultRuleFactory;
import fr.lirmm.graphik.integraal.core.factory.DefaultSubstitutionFactory;
import fr.lirmm.graphik.integraal.core.unifier.TermPartitionUtils;
import fr.lirmm.graphik.util.Partition;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import java.util.ArrayList;
import java.util.List;

public class QueryUnifier {
    private Rule rule;
    private ConjunctiveQuery query;
    private InMemoryAtomSet piece;
    private Partition<Term> partition;
    private Substitution associatedSubstitution;
    private static VariableGenerator varGenerator = new DefaultVariableGenerator("QUVar_");

    public QueryUnifier(InMemoryAtomSet piece, Partition<Term> partition, Rule rule, ConjunctiveQuery query) {
        Substitution map = DefaultSubstitutionFactory.instance().createSubstitution();
        for (Variable v : rule.getVariables()) {
            map.put(v, varGenerator.getFreshSymbol());
        }
        this.rule = DefaultRuleFactory.instance().create(rule.getLabel(), map.createImageOf(rule.getBody()), map.createImageOf(rule.getHead()));
        this.query = query;
        this.piece = piece;
        Partition<Term> part = new Partition<Term>();
        for (List list : partition) {
            part.addClass(new ArrayList<Term>(map.createImageOf(list)));
        }
        this.partition = part;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public void setPiece(InMemoryAtomSet piece) {
        this.piece = piece;
    }

    public void setSubstitution(Partition<Term> partition) {
        this.partition = partition;
    }

    public InMemoryAtomSet getPiece() {
        return this.piece;
    }

    public ConjunctiveQuery getQuery() {
        return this.query;
    }

    public Partition<Term> getPartition() {
        return this.partition;
    }

    public InMemoryAtomSet getImageOf(InMemoryAtomSet f) {
        InMemoryAtomSet atomset = null;
        if (this.associatedSubstitution == null) {
            this.associatedSubstitution = TermPartitionUtils.getAssociatedSubstitution(this.partition, this.query);
        }
        if (this.associatedSubstitution != null) {
            atomset = this.associatedSubstitution.createImageOf(f);
        }
        return atomset;
    }

    public Substitution getAssociatedSubstitution() {
        if (this.associatedSubstitution == null) {
            this.associatedSubstitution = TermPartitionUtils.getAssociatedSubstitution(this.partition, this.query);
        }
        return DefaultSubstitutionFactory.instance().createSubstitution(this.associatedSubstitution);
    }

    public String toString() {
        try {
            return "(QueryUnifier |  " + this.piece + " <=>" + this.rule.getHead() + " | = " + this.partition + ")";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public QueryUnifier aggregate(QueryUnifier u) {
        DefaultInMemoryAtomSet pieces = new DefaultInMemoryAtomSet();
        pieces.addAll(this.getPiece());
        pieces.addAll(u.getPiece());
        DefaultInMemoryAtomSet b = new DefaultInMemoryAtomSet();
        DefaultInMemoryAtomSet h = new DefaultInMemoryAtomSet();
        for (Atom a : this.getRule().getBody()) {
            b.add(a);
        }
        CloseableIterator it = this.getRule().getHead().iterator();
        while (it.hasNext()) {
            h.add((Atom)it.next());
        }
        it = u.getRule().getBody().iterator();
        while (it.hasNext()) {
            b.add((Atom)it.next());
        }
        it = u.getRule().getHead().iterator();
        while (it.hasNext()) {
            h.add((Atom)it.next());
        }
        Rule rule = DefaultRuleFactory.instance().create(b, h);
        Partition<Term> part = this.getPartition().join(u.getPartition());
        return new QueryUnifier(pieces, part, rule, this.getQuery());
    }

    public boolean isCompatible(QueryUnifier u) {
        for (Atom a1 : u.getPiece()) {
            for (Atom a2 : this.getPiece()) {
                if (!a1.equals(a2)) continue;
                return false;
            }
        }
        return TermPartitionUtils.getAssociatedSubstitution(this.getPartition().join(u.getPartition()), null) != null;
    }
}

