/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.unifier;

import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.unifier.DependencyChecker;
import fr.lirmm.graphik.integraal.core.unifier.QueryUnifier;
import java.util.Iterator;

public class RuleDependencyUtils {
    private RuleDependencyUtils() {
    }

    public static boolean validateUnifier(Rule r1, Rule r2, Substitution unifierSubs, DependencyChecker[] checkers) {
        for (DependencyChecker checker : checkers) {
            if (checker.isValidDependency(r1, r2, unifierSubs)) continue;
            return false;
        }
        return true;
    }

    public static void cleanUnifiers(Rule r1, Rule r2, Iterator<Substitution> unifiers, DependencyChecker[] checkers) {
        while (unifiers.hasNext()) {
            if (RuleDependencyUtils.validateUnifier(r1, r2, unifiers.next(), checkers)) continue;
            unifiers.remove();
        }
    }

    public static void cleanQueryUnifiers(Rule r1, Rule r2, Iterator<QueryUnifier> unifiers, DependencyChecker[] checkers) {
        while (unifiers.hasNext()) {
            if (RuleDependencyUtils.validateUnifier(r1, r2, unifiers.next().getAssociatedSubstitution(), checkers)) continue;
            unifiers.remove();
        }
    }
}

