/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.unifier;

import fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.core.factory.DefaultSubstitutionFactory;
import fr.lirmm.graphik.util.Partition;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

final class TermPartitionUtils {
    private TermPartitionUtils() {
    }

    public static boolean isAdmissible(Partition<Term> partition, Rule rule) {
        Term cst = null;
        Term exist = null;
        Term fr = null;
        for (Collection collection : partition) {
            cst = null;
            exist = null;
            fr = null;
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                Term t = (Term)i.next();
                if (t.isConstant()) {
                    if (cst != null || exist != null) {
                        if (!t.equals(cst)) {
                            return false;
                        }
                        i.remove();
                    }
                    cst = t;
                }
                if (rule.getExistentials().contains(t)) {
                    if (exist != null || cst != null || fr != null) {
                        if (!t.equals(exist)) {
                            return false;
                        }
                        i.remove();
                    }
                    exist = t;
                }
                if (!rule.getFrontier().contains(t)) continue;
                if (exist != null) {
                    return false;
                }
                fr = t;
            }
        }
        return true;
    }

    public static LinkedList<Term> getStickyVariable(Partition<Term> partition, LinkedList<Term> sep, Rule rule) {
        LinkedList<Term> res = new LinkedList<Term>();
        for (Collection collection : partition) {
            for (Term t : collection) {
                if (!rule.getExistentials().contains(t)) continue;
                for (Term x : collection) {
                    if (!sep.contains(x)) continue;
                    res.add(x);
                }
            }
        }
        return res;
    }

    public static Substitution getAssociatedSubstitution(Partition<Term> partition, ConjunctiveQuery context) {
        Substitution substitution = DefaultSubstitutionFactory.instance().createSubstitution();
        for (Collection collection : partition) {
            Iterator i = collection.iterator();
            Term representative = (Term)i.next();
            while (i.hasNext()) {
                Term t = (Term)i.next();
                if (representative.equals(t)) {
                    i.remove();
                    continue;
                }
                if (t.isConstant()) {
                    if (representative.isConstant()) {
                        return null;
                    }
                    representative = t;
                    continue;
                }
                if (!representative.isVariable() || context == null || context.getAnswerVariables().contains(representative) || !context.getAtomSet().getTerms().contains(t)) continue;
                representative = t;
            }
            for (Term t : collection) {
                if (t.equals(representative) || !t.isVariable()) continue;
                substitution.put((Variable)t, representative);
            }
        }
        return substitution;
    }
}

