/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.unifier.checker;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.api.core.unifier.DependencyChecker;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.integraal.core.HashMapSubstitution;
import fr.lirmm.graphik.integraal.core.atomset.DefaultInMemoryAtomSet;
import fr.lirmm.graphik.integraal.homomorphism.PureHomomorphism;
import fr.lirmm.graphik.util.stream.CloseableIteratorWithoutException;

public class RestrictedProductivityChecker
implements DependencyChecker {
    private static RestrictedProductivityChecker instance;

    protected RestrictedProductivityChecker() {
    }

    public static synchronized RestrictedProductivityChecker instance() {
        if (instance == null) {
            instance = new RestrictedProductivityChecker();
        }
        return instance;
    }

    @Override
    public boolean isValidDependency(Rule r1, Rule r2, Substitution s) {
        HashMapSubstitution sub = new HashMapSubstitution(s);
        for (Variable v : r2.getFrontier()) {
            if (sub.getTerms().contains(v)) continue;
            sub.put(v, v);
        }
        InMemoryAtomSet b1 = sub.createImageOf(r1.getBody());
        InMemoryAtomSet h1 = sub.createImageOf(r1.getHead());
        InMemoryAtomSet b2 = sub.createImageOf(r2.getBody());
        DefaultInMemoryAtomSet f = new DefaultInMemoryAtomSet();
        f.addAll((CloseableIteratorWithoutException<? extends Atom>)b1.iterator());
        f.addAll((CloseableIteratorWithoutException<? extends Atom>)h1.iterator());
        f.addAll((CloseableIteratorWithoutException<? extends Atom>)b2.iterator());
        try {
            return !PureHomomorphism.instance().exist(r2.getHead(), (AtomSet)f, (Substitution)sub);
        }
        catch (HomomorphismException e) {
            e.printStackTrace();
            throw new Error("Untreated exception");
        }
    }
}

