/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.forward_chaining;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Query;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.forward_chaining.AbstractChase;
import fr.lirmm.graphik.integraal.api.forward_chaining.ChaseException;
import fr.lirmm.graphik.integraal.api.forward_chaining.ChaseHaltingCondition;
import fr.lirmm.graphik.integraal.api.forward_chaining.RuleApplier;
import fr.lirmm.graphik.integraal.api.homomorphism.Homomorphism;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismWithCompilation;
import fr.lirmm.graphik.integraal.core.atomset.DefaultInMemoryAtomSet;
import fr.lirmm.graphik.integraal.core.atomset.graph.DefaultInMemoryGraphStore;
import fr.lirmm.graphik.integraal.core.ruleset.IndexedByBodyPredicatesRuleSet;
import fr.lirmm.graphik.integraal.forward_chaining.rule_applier.DefaultRuleApplier;
import fr.lirmm.graphik.integraal.forward_chaining.rule_applier.DefaultRuleApplierWithCompilation;
import fr.lirmm.graphik.integraal.forward_chaining.rule_applier.RestrictedChaseRuleApplier;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class BreadthFirstChase
extends AbstractChase<Rule, AtomSet> {
    private IndexedByBodyPredicatesRuleSet ruleSet;
    private AtomSet atomSet;
    private InMemoryAtomSet tmpData = new DefaultInMemoryAtomSet();
    private Map<Rule, AtomSet> rulesToCheck;
    private Map<Rule, AtomSet> nextRulesToCheck;

    public BreadthFirstChase(Iterator<Rule> rules, AtomSet atomSet) {
        super(new RestrictedChaseRuleApplier());
        this.atomSet = atomSet;
        this.ruleSet = new IndexedByBodyPredicatesRuleSet();
        this.init(rules);
    }

    public BreadthFirstChase(Iterable<Rule> rules, AtomSet atomSet) {
        super(new RestrictedChaseRuleApplier());
        this.atomSet = atomSet;
        this.ruleSet = new IndexedByBodyPredicatesRuleSet();
        this.init(rules.iterator());
    }

    public BreadthFirstChase(Iterator<Rule> rules, AtomSet atomSet, RuleApplier<Rule, AtomSet> ruleApplier) {
        super(ruleApplier);
        this.atomSet = atomSet;
        this.ruleSet = new IndexedByBodyPredicatesRuleSet();
        this.init(rules);
    }

    public BreadthFirstChase(Iterable<Rule> rules, AtomSet atomSet, RuleApplier<Rule, AtomSet> ruleApplier) {
        this(rules.iterator(), atomSet, ruleApplier);
    }

    public BreadthFirstChase(Iterable<Rule> rules, AtomSet atomSet, Homomorphism<Query, AtomSet> solver) {
        this(rules, atomSet, new DefaultRuleApplier<AtomSet>(solver));
    }

    public BreadthFirstChase(Iterable<Rule> rules, AtomSet atomSet, ChaseHaltingCondition haltingCondition) {
        this(rules, atomSet, new DefaultRuleApplier<AtomSet>(haltingCondition));
    }

    public BreadthFirstChase(Iterable<Rule> rules, AtomSet atomSet, Homomorphism<Query, AtomSet> solver, ChaseHaltingCondition haltingCondition) {
        this(rules, atomSet, new DefaultRuleApplier<AtomSet>(solver, haltingCondition));
    }

    public BreadthFirstChase(Iterable<Rule> rules, AtomSet atomSet, RulesCompilation compilation) {
        this(rules, atomSet, new DefaultRuleApplierWithCompilation<AtomSet>(compilation));
    }

    public BreadthFirstChase(Iterator<Rule> rules, AtomSet atomSet, RulesCompilation compilation) {
        this(rules, atomSet, new DefaultRuleApplierWithCompilation<AtomSet>(compilation));
    }

    public BreadthFirstChase(Iterable<Rule> rules, AtomSet atomSet, RulesCompilation compilation, HomomorphismWithCompilation<Query, AtomSet> h) {
        this(rules, atomSet, new DefaultRuleApplierWithCompilation<AtomSet>(h, compilation));
    }

    private void init(Iterator<Rule> rules) {
        this.nextRulesToCheck = new TreeMap<Rule, AtomSet>();
        while (rules.hasNext()) {
            Rule r = rules.next();
            this.ruleSet.add(r);
            this.nextRulesToCheck.put(r, this.atomSet);
        }
    }

    @Override
    public void next() throws ChaseException {
        this.rulesToCheck = this.nextRulesToCheck;
        this.nextRulesToCheck = new TreeMap<Rule, AtomSet>();
        try {
            if (!this.rulesToCheck.isEmpty()) {
                if (this.getProfiler().isProfilingEnabled()) {
                    this.getProfiler().start("saturationTime");
                }
                for (Map.Entry<Rule, AtomSet> e : this.rulesToCheck.entrySet()) {
                    String key = null;
                    Rule rule = e.getKey();
                    AtomSet data = e.getValue();
                    if (this.getProfiler().isProfilingEnabled()) {
                        key = "Rule " + rule.getLabel() + " application time";
                        this.getProfiler().clear(key);
                        this.getProfiler().trace(rule.toString());
                        this.getProfiler().start(key);
                    }
                    CloseableIterator<Atom> it = this.getRuleApplier().delegatedApply(rule, data, this.atomSet);
                    this.tmpData.addAll(it);
                    it.close();
                    if (!this.getProfiler().isProfilingEnabled()) continue;
                    this.getProfiler().stop(key);
                }
                this.dispatchNewData(this.tmpData);
                this.atomSet.addAll(this.tmpData);
                this.tmpData.clear();
                if (this.getProfiler().isProfilingEnabled()) {
                    this.getProfiler().stop("saturationTime");
                }
            }
        }
        catch (Exception e) {
            throw new ChaseException("An error occured during saturation step.", e);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.nextRulesToCheck.isEmpty();
    }

    protected void dispatchNewData(InMemoryAtomSet newData) throws ChaseException {
        for (Atom a : newData) {
            Predicate p = a.getPredicate();
            for (Rule r : this.ruleSet.getRulesByBodyPredicate(p)) {
                if (BreadthFirstChase.linearRuleCheck(r)) {
                    AtomSet set = this.nextRulesToCheck.get(r);
                    if (set == null) {
                        set = new DefaultInMemoryGraphStore();
                        this.nextRulesToCheck.put(r, set);
                    }
                    try {
                        set.add(a);
                        continue;
                    }
                    catch (AtomSetException e) {
                        throw new ChaseException("Exception while adding data into a tmp store", e);
                    }
                }
                this.nextRulesToCheck.put(r, this.atomSet);
            }
        }
    }

    private static boolean linearRuleCheck(Rule r) {
        CloseableIterator it = r.getBody().iterator();
        if (!it.hasNext()) {
            return false;
        }
        it.next();
        return !it.hasNext();
    }
}

