/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.forward_chaining.rule_applier;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.Query;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.forward_chaining.ChaseHaltingCondition;
import fr.lirmm.graphik.integraal.api.forward_chaining.RuleApplicationException;
import fr.lirmm.graphik.integraal.api.forward_chaining.RuleApplier;
import fr.lirmm.graphik.integraal.api.homomorphism.Homomorphism;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismFactoryException;
import fr.lirmm.graphik.integraal.forward_chaining.halting_condition.RestrictedChaseHaltingCondition;
import fr.lirmm.graphik.integraal.forward_chaining.rule_applier.RuleApplierIterator;
import fr.lirmm.graphik.integraal.homomorphism.SmartHomomorphism;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;

public abstract class AbstractRuleApplier<T extends AtomSet>
implements RuleApplier<Rule, T> {
    private ChaseHaltingCondition haltingCondition;
    private Homomorphism<? super Query, ? super T> solver;

    public AbstractRuleApplier() {
        this(SmartHomomorphism.instance());
    }

    public AbstractRuleApplier(Homomorphism<? super Query, ? super T> homomorphismSolver) {
        this(homomorphismSolver, new RestrictedChaseHaltingCondition());
    }

    public AbstractRuleApplier(ChaseHaltingCondition haltingCondition) {
        this(SmartHomomorphism.instance(), haltingCondition);
    }

    public AbstractRuleApplier(Homomorphism<? super Query, ? super T> homomorphismSolver, ChaseHaltingCondition haltingCondition) {
        this.haltingCondition = haltingCondition;
        this.solver = homomorphismSolver;
    }

    protected abstract Query generateQuery(Rule var1);

    @Override
    public boolean apply(Rule rule, T atomSet) throws RuleApplicationException {
        boolean isChanged = false;
        Query query = this.generateQuery(rule);
        try {
            CloseableIterator<Substitution> subIt = this.executeQuery(query, atomSet);
            while (subIt.hasNext()) {
                Substitution substitution = subIt.next();
                CloseableIterator<Atom> it = this.getHaltingCondition().apply(rule, substitution, (AtomSet)atomSet);
                if (!it.hasNext()) continue;
                atomSet.addAll(it);
                isChanged = true;
            }
            subIt.close();
        }
        catch (HomomorphismFactoryException e) {
            throw new RuleApplicationException("Error during rule application", e);
        }
        catch (HomomorphismException e) {
            throw new RuleApplicationException("Error during rule application", e);
        }
        catch (AtomSetException e) {
            throw new RuleApplicationException("Error during rule application", e);
        }
        catch (IteratorException e) {
            throw new RuleApplicationException("Error during rule application", e);
        }
        return isChanged;
    }

    @Override
    public CloseableIterator<Atom> delegatedApply(Rule rule, T atomSet) throws RuleApplicationException {
        return this.delegatedApply(rule, atomSet, atomSet);
    }

    @Override
    public CloseableIterator<Atom> delegatedApply(Rule rule, T atomSetOnWichQuerying, T atomSetOnWichCheck) throws RuleApplicationException {
        CloseableIterator<Substitution> subIt;
        Query query = this.generateQuery(rule);
        try {
            subIt = this.executeQuery(query, atomSetOnWichQuerying);
        }
        catch (HomomorphismFactoryException e) {
            throw new RuleApplicationException("Error during rule application", e);
        }
        catch (HomomorphismException e) {
            throw new RuleApplicationException("Error during rule application", e);
        }
        return new RuleApplierIterator(subIt, rule, (AtomSet)atomSetOnWichCheck, this.haltingCondition);
    }

    protected ChaseHaltingCondition getHaltingCondition() {
        return this.haltingCondition;
    }

    protected Homomorphism<? super Query, ? super T> getSolver() {
        return this.solver;
    }

    protected CloseableIterator<Substitution> executeQuery(Query query, T atomSet) throws HomomorphismFactoryException, HomomorphismException {
        return this.solver.execute(query, atomSet);
    }
}

