/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.forward_chaining.rule_applier;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.api.forward_chaining.RuleApplicationException;
import fr.lirmm.graphik.integraal.api.forward_chaining.RuleApplier;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.integraal.core.RuleWrapper2ConjunctiveQueryWithNegatedParts;
import fr.lirmm.graphik.integraal.forward_chaining.rule_applier.DefaultRuleApplier;
import fr.lirmm.graphik.integraal.homomorphism.SmartHomomorphism;
import fr.lirmm.graphik.util.stream.AbstractCloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;

public class RestrictedChaseRuleApplier<T extends AtomSet>
implements RuleApplier<Rule, T> {
    private static final RuleApplier<Rule, AtomSet> FALLBACK = new DefaultRuleApplier<AtomSet>();

    @Override
    public boolean apply(Rule rule, T atomSet) throws RuleApplicationException {
        try {
            boolean res = false;
            RuleWrapper2ConjunctiveQueryWithNegatedParts query = new RuleWrapper2ConjunctiveQueryWithNegatedParts(rule);
            CloseableIterator<Substitution> results = SmartHomomorphism.instance().execute(query, (AtomSet)atomSet);
            while (results.hasNext()) {
                res = true;
                Substitution proj = results.next();
                for (Variable t : rule.getExistentials()) {
                    proj.put(t, atomSet.getFreshSymbolGenerator().getFreshSymbol());
                }
                CloseableIterator it = proj.createImageOf(rule.getHead()).iterator();
                while (it.hasNext()) {
                    atomSet.add((Atom)it.next());
                }
            }
            return res;
        }
        catch (HomomorphismException e) {
            throw new RuleApplicationException("", e);
        }
        catch (AtomSetException e) {
            throw new RuleApplicationException("", e);
        }
        catch (IteratorException e) {
            throw new RuleApplicationException("", e);
        }
    }

    @Override
    public CloseableIterator<Atom> delegatedApply(Rule rule, T atomSet) throws RuleApplicationException {
        try {
            RuleWrapper2ConjunctiveQueryWithNegatedParts query = new RuleWrapper2ConjunctiveQueryWithNegatedParts(rule);
            CloseableIterator<Substitution> results = SmartHomomorphism.instance().execute(query, (AtomSet)atomSet);
            return new RuleApplierIterator(results, rule, (AtomSet)atomSet);
        }
        catch (HomomorphismException e) {
            throw new RuleApplicationException("", e);
        }
    }

    @Override
    public CloseableIterator<Atom> delegatedApply(Rule rule, T atomSetOnWichQuerying, T atomSetOnWichCheck) throws RuleApplicationException {
        if (atomSetOnWichQuerying == atomSetOnWichCheck) {
            return this.delegatedApply(rule, atomSetOnWichQuerying);
        }
        return FALLBACK.delegatedApply(rule, (AtomSet)atomSetOnWichQuerying, (AtomSet)atomSetOnWichCheck);
    }

    private static class RuleApplierIterator
    extends AbstractCloseableIterator<Atom> {
        private CloseableIterator<Substitution> substitutionIt;
        private CloseableIterator<Atom> localIt;
        private boolean hasNextCallDone;
        private Rule rule;
        private AtomSet atomset;

        public RuleApplierIterator(CloseableIterator<Substitution> it, Rule rule, AtomSet atomset) {
            this.substitutionIt = it;
            this.rule = rule;
            this.atomset = atomset;
            this.hasNextCallDone = false;
            this.localIt = null;
        }

        @Override
        public boolean hasNext() throws IteratorException {
            if (!this.hasNextCallDone) {
                this.hasNextCallDone = true;
                if (this.localIt != null && !this.localIt.hasNext()) {
                    this.localIt.close();
                    this.localIt = null;
                }
                while ((this.localIt == null || !this.localIt.hasNext()) && this.substitutionIt.hasNext()) {
                    Substitution proj = this.substitutionIt.next();
                    for (Variable t : this.rule.getExistentials()) {
                        proj.put(t, this.atomset.getFreshSymbolGenerator().getFreshSymbol());
                    }
                    this.localIt = proj.createImageOf(this.rule.getHead()).iterator();
                }
            }
            return this.localIt != null && this.localIt.hasNext();
        }

        @Override
        public Atom next() throws IteratorException {
            if (!this.hasNextCallDone) {
                this.hasNext();
            }
            this.hasNextCallDone = false;
            return this.localIt.next();
        }

        @Override
        public void close() {
            if (this.localIt != null) {
                this.localIt.close();
            }
            this.substitutionIt.close();
        }
    }
}

