/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.forward_chaining.rule_applier;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.forward_chaining.ChaseHaltingCondition;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismFactoryException;
import fr.lirmm.graphik.util.stream.AbstractCloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;

class RuleApplierIterator
extends AbstractCloseableIterator<Atom> {
    private CloseableIterator<Substitution> substitutionIt;
    private CloseableIterator<Atom> localIt;
    private boolean hasNextCallDone;
    private Rule rule;
    private ChaseHaltingCondition haltingCondition;
    private AtomSet atomset;

    public RuleApplierIterator(CloseableIterator<Substitution> it, Rule rule, AtomSet atomset, ChaseHaltingCondition haltingCondition) {
        this.substitutionIt = it;
        this.localIt = null;
        this.hasNextCallDone = false;
        this.rule = rule;
        this.haltingCondition = haltingCondition;
        this.atomset = atomset;
    }

    @Override
    public boolean hasNext() throws IteratorException {
        if (!this.hasNextCallDone) {
            this.hasNextCallDone = true;
            if (this.localIt != null && !this.localIt.hasNext()) {
                this.localIt.close();
                this.localIt = null;
            }
            while ((this.localIt == null || !this.localIt.hasNext()) && this.substitutionIt.hasNext()) {
                try {
                    this.localIt = this.haltingCondition.apply(this.rule, this.substitutionIt.next(), this.atomset);
                }
                catch (HomomorphismFactoryException e) {
                    throw new IteratorException("Error during rule application", e);
                }
                catch (HomomorphismException e) {
                    throw new IteratorException("Error during rule application", e);
                }
            }
        }
        return this.localIt != null && this.localIt.hasNext();
    }

    @Override
    public Atom next() throws IteratorException {
        if (!this.hasNextCallDone) {
            this.hasNext();
        }
        this.hasNextCallDone = false;
        return this.localIt.next();
    }

    @Override
    public void close() {
        if (this.localIt != null) {
            this.localIt.close();
        }
        this.substitutionIt.close();
    }
}

