/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.core.HashMapSubstitution;
import fr.lirmm.graphik.util.stream.converter.ConversionException;
import fr.lirmm.graphik.util.stream.converter.Converter;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class Atom2SubstitutionConverter
implements Converter<Atom, Substitution> {
    private Map<Variable, Integer> variables = new TreeMap<Variable, Integer>();
    private List<Term> ans;

    public Atom2SubstitutionConverter(Atom query, List<Term> ans) {
        this.ans = ans;
        int i = 0;
        for (Term t : query) {
            if (ans.contains(t)) {
                this.variables.put((Variable)t, i);
            }
            ++i;
        }
    }

    public Atom2SubstitutionConverter(Atom query, List<Term> ans, Substitution rew) {
        this.ans = ans;
        int i = 0;
        for (Term t : query) {
            if (ans.contains(t) || rew.getValues().contains(t)) {
                this.variables.put((Variable)t, i);
            }
            ++i;
        }
        for (Variable var : rew.getTerms()) {
            this.variables.put(var, this.variables.get(rew.createImageOf(var)));
        }
    }

    @Override
    public Substitution convert(Atom object) throws ConversionException {
        HashMapSubstitution s = new HashMapSubstitution();
        for (Term var : this.ans) {
            if (!var.isVariable() || !this.variables.containsKey(var)) continue;
            s.put((Variable)var, object.getTerm(this.variables.get(var)));
        }
        return s;
    }
}

