/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.ConjunctiveQueryWithNegatedParts;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismWithCompilation;
import fr.lirmm.graphik.integraal.homomorphism.AbstractHomomorphismWithCompilation;
import fr.lirmm.graphik.integraal.homomorphism.Atom2SubstitutionConverter;
import fr.lirmm.graphik.integraal.homomorphism.NegFilter;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import fr.lirmm.graphik.util.stream.CloseableIteratorAggregator;
import fr.lirmm.graphik.util.stream.converter.ConverterCloseableIterator;
import fr.lirmm.graphik.util.stream.filter.AndFilter;
import fr.lirmm.graphik.util.stream.filter.Filter;
import fr.lirmm.graphik.util.stream.filter.FilterIterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AtomicQueryHomomorphismWithNegatedParts
extends AbstractHomomorphismWithCompilation<ConjunctiveQueryWithNegatedParts, AtomSet>
implements HomomorphismWithCompilation<ConjunctiveQueryWithNegatedParts, AtomSet> {
    private static final AtomicQueryHomomorphismWithNegatedParts INSTANCE = new AtomicQueryHomomorphismWithNegatedParts();

    public static AtomicQueryHomomorphismWithNegatedParts instance() {
        return INSTANCE;
    }

    private AtomicQueryHomomorphismWithNegatedParts() {
    }

    @Override
    public CloseableIterator<Substitution> execute(ConjunctiveQueryWithNegatedParts query, AtomSet data, RulesCompilation compilation, Substitution s) throws HomomorphismException {
        try {
            Atom atom = (Atom)query.getPositivePart().iterator().next();
            List<Term> ans = query.getAnswerVariables();
            LinkedList<ConverterCloseableIterator<Atom, Substitution>> iteratorsList = new LinkedList<ConverterCloseableIterator<Atom, Substitution>>();
            for (Pair<Atom, Substitution> im : compilation.getRewritingOf(atom)) {
                iteratorsList.add(new ConverterCloseableIterator<Atom, Substitution>(data.match((Atom)im.getLeft(), s), new Atom2SubstitutionConverter((Atom)im.getLeft(), ans, (Substitution)im.getRight())));
            }
            CloseableIteratorAggregator subIt = new CloseableIteratorAggregator(new CloseableIteratorAdapter(iteratorsList.iterator()));
            Set<Variable> variablesPositivePart = query.getPositivePart().getVariables();
            Filter[] filtersForNegatedParts = new Filter[query.getNegatedParts().size()];
            int i = 0;
            for (InMemoryAtomSet negPart : query.getNegatedParts()) {
                SetUtils.SetView frontier = SetUtils.intersection(variablesPositivePart, negPart.getVariables());
                filtersForNegatedParts[i++] = new NegFilter(negPart, (Set<Variable>)frontier, data, compilation);
            }
            AndFilter filter = new AndFilter(filtersForNegatedParts);
            return new FilterIterator(subIt, filter);
        }
        catch (AtomSetException e) {
            throw new HomomorphismException(e);
        }
    }
}

