/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism;

import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismWithCompilation;
import fr.lirmm.graphik.integraal.homomorphism.AbstractHomomorphismWithCompilation;
import fr.lirmm.graphik.integraal.homomorphism.BacktrackIterator;
import fr.lirmm.graphik.integraal.homomorphism.backjumping.BackJumping;
import fr.lirmm.graphik.integraal.homomorphism.backjumping.GraphBaseBackJumping;
import fr.lirmm.graphik.integraal.homomorphism.bbc.BCC;
import fr.lirmm.graphik.integraal.homomorphism.bootstrapper.Bootstrapper;
import fr.lirmm.graphik.integraal.homomorphism.bootstrapper.StarBootstrapper;
import fr.lirmm.graphik.integraal.homomorphism.forward_checking.ForwardChecking;
import fr.lirmm.graphik.integraal.homomorphism.forward_checking.NFC2;
import fr.lirmm.graphik.integraal.homomorphism.scheduler.DefaultScheduler;
import fr.lirmm.graphik.integraal.homomorphism.scheduler.Scheduler;
import fr.lirmm.graphik.integraal.homomorphism.utils.EqualityHandlerConverter;
import fr.lirmm.graphik.integraal.homomorphism.utils.EqualityUtils;
import fr.lirmm.graphik.util.profiler.Profilable;
import fr.lirmm.graphik.util.stream.AbstractCloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.converter.ConverterCloseableIterator;
import java.util.Collections;
import org.apache.commons.lang3.tuple.Pair;

public class BacktrackHomomorphism
extends AbstractHomomorphismWithCompilation<ConjunctiveQuery, AtomSet>
implements HomomorphismWithCompilation<ConjunctiveQuery, AtomSet>,
Profilable {
    private Scheduler scheduler;
    private Bootstrapper bootstrapper;
    private ForwardChecking fc;
    private BackJumping bj;

    public BacktrackHomomorphism() {
        this(true);
    }

    public BacktrackHomomorphism(Bootstrapper bs) {
        this(true, bs, (ForwardChecking)new NFC2(), (BackJumping)new GraphBaseBackJumping());
    }

    public BacktrackHomomorphism(ForwardChecking fc) {
        this(true, (Bootstrapper)StarBootstrapper.instance(), fc, (BackJumping)new GraphBaseBackJumping());
    }

    public BacktrackHomomorphism(Bootstrapper bs, ForwardChecking fc, BackJumping bj) {
        this(true, bs, fc, bj);
    }

    public BacktrackHomomorphism(boolean enableBCC) {
        this(enableBCC, (Bootstrapper)StarBootstrapper.instance(), (ForwardChecking)new NFC2(), (BackJumping)new GraphBaseBackJumping());
    }

    public BacktrackHomomorphism(boolean enableBCC, Bootstrapper bs) {
        this(enableBCC, bs, (ForwardChecking)new NFC2(), (BackJumping)new GraphBaseBackJumping());
    }

    public BacktrackHomomorphism(boolean enableBCC, ForwardChecking fc) {
        this(enableBCC, (Bootstrapper)StarBootstrapper.instance(), fc, (BackJumping)new GraphBaseBackJumping());
    }

    public BacktrackHomomorphism(boolean enableBCC, BackJumping bj) {
        this(enableBCC, (Bootstrapper)StarBootstrapper.instance(), (ForwardChecking)new NFC2(), bj);
    }

    public BacktrackHomomorphism(boolean enableBCC, Bootstrapper bs, ForwardChecking fc, BackJumping bj) {
        if (enableBCC) {
            BCC bcc = new BCC(bj, true);
            this.scheduler = bcc.getBCCScheduler();
            this.bj = bcc.getBCCBackJumping();
        } else {
            this.scheduler = DefaultScheduler.instance();
            this.bj = bj;
        }
        this.bootstrapper = bs;
        this.fc = fc;
    }

    public BacktrackHomomorphism(BCC bcc) {
        this(bcc, (Bootstrapper)StarBootstrapper.instance(), (ForwardChecking)new NFC2(), (BackJumping)new GraphBaseBackJumping());
    }

    public BacktrackHomomorphism(BCC bcc, Bootstrapper bs) {
        this(bcc, bs, (ForwardChecking)new NFC2(), (BackJumping)new GraphBaseBackJumping());
    }

    public BacktrackHomomorphism(BCC bcc, ForwardChecking fc) {
        this(bcc, (Bootstrapper)StarBootstrapper.instance(), fc, (BackJumping)new GraphBaseBackJumping());
    }

    public BacktrackHomomorphism(BCC bcc, BackJumping bj) {
        this(bcc, (Bootstrapper)StarBootstrapper.instance(), (ForwardChecking)new NFC2(), bj);
    }

    public BacktrackHomomorphism(BCC bcc, Bootstrapper bs, ForwardChecking fc, BackJumping bj) {
        this.scheduler = bcc.getBCCScheduler();
        this.bj = bcc.getBCCBackJumping();
        this.bootstrapper = bs;
        this.fc = fc;
    }

    public BacktrackHomomorphism(Scheduler s) {
        this(s, (Bootstrapper)StarBootstrapper.instance(), (ForwardChecking)new NFC2(), (BackJumping)new GraphBaseBackJumping());
    }

    public BacktrackHomomorphism(Scheduler s, Bootstrapper bs) {
        this(s, bs, (ForwardChecking)new NFC2(), (BackJumping)new GraphBaseBackJumping());
    }

    public BacktrackHomomorphism(Scheduler s, ForwardChecking fc) {
        this(s, (Bootstrapper)StarBootstrapper.instance(), fc, (BackJumping)new GraphBaseBackJumping());
    }

    public BacktrackHomomorphism(Scheduler s, BackJumping bj) {
        this(s, (Bootstrapper)StarBootstrapper.instance(), (ForwardChecking)new NFC2(), bj);
    }

    public BacktrackHomomorphism(Scheduler s, Bootstrapper bs, ForwardChecking fc, BackJumping bj) {
        this.fc = fc;
        this.bj = bj;
        this.scheduler = s;
        this.bootstrapper = bs;
    }

    @Override
    public CloseableIterator<Substitution> execute(ConjunctiveQuery q, AtomSet a, RulesCompilation compilation, Substitution s) throws HomomorphismException {
        Pair<ConjunctiveQuery, Substitution> pair = EqualityUtils.processEquality(q);
        AbstractCloseableIterator results = new BacktrackIterator(((ConjunctiveQuery)pair.getLeft()).getAtomSet(), Collections.emptyList(), a, ((ConjunctiveQuery)pair.getLeft()).getAnswerVariables(), this.scheduler, this.bootstrapper, this.fc, this.bj, compilation, s, this.getProfiler());
        if (!((Substitution)pair.getRight()).getTerms().isEmpty()) {
            results = new ConverterCloseableIterator<Substitution, Substitution>(results, new EqualityHandlerConverter((Substitution)pair.getRight()));
        }
        return results;
    }
}

