/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.integraal.core.DefaultConjunctiveQuery;
import fr.lirmm.graphik.integraal.homomorphism.BacktrackHomomorphismPattern;
import fr.lirmm.graphik.integraal.homomorphism.VarSharedData;
import fr.lirmm.graphik.integraal.homomorphism.backjumping.BackJumping;
import fr.lirmm.graphik.integraal.homomorphism.bootstrapper.Bootstrapper;
import fr.lirmm.graphik.integraal.homomorphism.forward_checking.ForwardChecking;
import fr.lirmm.graphik.integraal.homomorphism.scheduler.Scheduler;
import fr.lirmm.graphik.util.profiler.Profiler;
import fr.lirmm.graphik.util.stream.CloseableIterableWithoutException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections4.SetUtils;

class BacktrackIteratorData {
    Scheduler scheduler;
    Bootstrapper bootstrapper;
    ForwardChecking fc;
    BackJumping bj;
    InMemoryAtomSet query;
    AtomSet data;
    RulesCompilation compilation;
    VarSharedData[] varsOrder;
    Map<Variable, Integer> index;
    int levelMax;
    List<Term> ans;
    Collection<InMemoryAtomSet> negParts;
    Profiler profiler;
    boolean isOpen = false;

    public BacktrackIteratorData(InMemoryAtomSet query, Set<Variable> variablesToParameterize, Collection<InMemoryAtomSet> negParts, AtomSet data, List<Term> ans, Scheduler scheduler, Bootstrapper bootstrapper, ForwardChecking fc, BackJumping bj, RulesCompilation compilation, Profiler profiler) throws HomomorphismException {
        this.query = query;
        this.negParts = negParts;
        this.data = data;
        this.ans = ans;
        this.scheduler = scheduler;
        this.bootstrapper = bootstrapper;
        this.fc = fc;
        this.bj = bj;
        this.fc.setBackJumping(bj);
        this.compilation = compilation;
        this.profiler = profiler;
        this.bootstrapper.setProfiler(profiler);
        this.scheduler.setProfiler(profiler);
        this.fc.setProfiler(profiler);
        this.bj.setProfiler(profiler);
        this.preprocessing(variablesToParameterize, profiler);
    }

    private void preprocessing(Set<Variable> variablesToParameterize, Profiler profiler) throws HomomorphismException {
        profiler.start("preprocessingTime");
        this.varsOrder = this.scheduler.execute(this.query, variablesToParameterize, this.ans, this.data, this.compilation);
        this.levelMax = this.varsOrder.length - 2;
        if (profiler.isProfilingEnabled()) {
            this.profilingVarOrder(this.varsOrder, profiler);
        }
        this.index = new TreeMap<Variable, Integer>();
        for (VarSharedData v : this.varsOrder) {
            if (v.value == null) continue;
            this.index.put(v.value, v.level);
        }
        if (this.ans.isEmpty()) {
            this.varsOrder[this.levelMax + 1].previousLevel = -1;
        }
        BacktrackIteratorData.computeAtomOrder(this.query, this.varsOrder, this.index);
        this.fc.init(this.varsOrder, this.index);
        this.bj.init(this.varsOrder);
        Set<Variable> allVarsFromH = this.query.getVariables();
        allVarsFromH.removeAll(variablesToParameterize);
        for (InMemoryAtomSet negPart : this.negParts) {
            Set<Variable> allVarsFromNegPart = negPart.getVariables();
            allVarsFromNegPart.removeAll(variablesToParameterize);
            SetUtils.SetView frontierNotParametrized = SetUtils.intersection(allVarsFromH, allVarsFromNegPart);
            this.varsOrder[this.maxLevel((Set<Variable>)frontierNotParametrized)].negatedPartsToCheck.add(BacktrackHomomorphismPattern.instance().prepareHomomorphism(new DefaultConjunctiveQuery(negPart, Collections.emptyList()), (Set<Variable>)SetUtils.union(variablesToParameterize, (Set)frontierNotParametrized), this.data, this.compilation));
        }
        profiler.stop("preprocessingTime");
    }

    public void clear() {
        this.scheduler.clear();
        this.fc.clear();
        this.bj.clear();
    }

    private static void computeAtomOrder(CloseableIterableWithoutException<Atom> atomset, VarSharedData[] vars, Map<Variable, Integer> index) {
        for (int i = 0; i < vars.length; ++i) {
            vars[i].preAtoms = new HashSet<Atom>();
            vars[i].postAtoms = new HashSet<Atom>();
            vars[i].postVars = new HashSet<VarSharedData>();
            vars[i].preVars = new TreeSet<VarSharedData>();
        }
        for (Atom a : atomset) {
            int rank = 0;
            for (Variable t : a.getVariables()) {
                Integer idx = index.get(t);
                if (idx == null) continue;
                int tmp = vars[idx.intValue()].level;
                vars[tmp].postAtoms.add(a);
                if (rank >= tmp) continue;
                rank = tmp;
            }
            vars[rank].postAtoms.remove(a);
            vars[rank].preAtoms.add(a);
        }
        for (int i = 0; i < vars.length; ++i) {
            for (Atom a : vars[i].postAtoms) {
                for (Variable t : a.getVariables()) {
                    Integer idx = index.get(t);
                    if (idx == null || vars[idx.intValue()].level <= i) continue;
                    vars[i].postVars.add(vars[idx]);
                    vars[idx.intValue()].preVars.add(vars[i]);
                }
            }
        }
    }

    private int maxLevel(Set<Variable> frontier) {
        int max = 0;
        for (Variable v : frontier) {
            int level = this.index.get(v);
            if (level <= max) continue;
            max = level;
        }
        return max;
    }

    private void profilingVarOrder(VarSharedData[] varsOrder, Profiler profiler) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < varsOrder.length - 1; ++i) {
            sb.append(varsOrder[i].value.toString());
            sb.append(' ');
        }
        profiler.incr("__#cqs", 1);
        profiler.put("SchedulingSubQuery" + profiler.get("__#cqs"), sb.toString());
    }
}

