/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.integraal.core.Substitutions;
import fr.lirmm.graphik.integraal.homomorphism.AbstractHomomorphismWithCompilation;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.Iterators;
import java.util.Iterator;
import org.apache.commons.lang3.tuple.Pair;

public class FullyInstantiatedQueryHomomorphism
extends AbstractHomomorphismWithCompilation<ConjunctiveQuery, AtomSet> {
    private static final FullyInstantiatedQueryHomomorphism INSTANCE = new FullyInstantiatedQueryHomomorphism();

    private FullyInstantiatedQueryHomomorphism() {
    }

    public static FullyInstantiatedQueryHomomorphism instance() {
        return INSTANCE;
    }

    @Override
    public CloseableIterator<Substitution> execute(ConjunctiveQuery q, AtomSet a, Substitution s) throws HomomorphismException {
        try {
            CloseableIterator queryAtomsIterator = q.getAtomSet().iterator();
            boolean contains = true;
            while (contains && queryAtomsIterator.hasNext()) {
                contains = a.contains(s.createImageOf((Atom)queryAtomsIterator.next()));
            }
            if (contains) {
                return Iterators.singletonIterator(Substitutions.emptySubstitution());
            }
            return Iterators.emptyIterator();
        }
        catch (AtomSetException e) {
            throw new HomomorphismException(e);
        }
    }

    @Override
    public CloseableIterator<Substitution> execute(ConjunctiveQuery q, AtomSet a, RulesCompilation rc, Substitution s) throws HomomorphismException {
        try {
            CloseableIterator it = q.getAtomSet().iterator();
            boolean contains = true;
            while (contains && it.hasNext()) {
                Pair<Atom, Substitution> im;
                Atom atom = (Atom)it.next();
                boolean containsAtom = false;
                Iterator<Pair<Atom, Substitution>> iterator = rc.getRewritingOf(s.createImageOf(atom)).iterator();
                while (iterator.hasNext() && !(containsAtom = a.contains((Atom)(im = iterator.next()).getLeft()))) {
                }
                contains = containsAtom;
            }
            if (contains) {
                return Iterators.singletonIterator(Substitutions.emptySubstitution());
            }
            return Iterators.emptyIterator();
        }
        catch (AtomSetException e) {
            throw new HomomorphismException(e);
        }
    }
}

